/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.mts.AliMtsConfig:20181230230343
 *
 * AliMtsConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.mts;

import cc.zuv.service.aliyun.AliAccount;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-28 18:04
 * @modify.date     2018-12-28 18:04
 */

@Getter
@Setter
@Configuration
@ConditionalOnProperty(name = "aliyun.mts.enabled", havingValue = "true")
//@ConditionalOnProperty(value = "aliyun.mts.enabled", matchIfMissing = false)
@ConfigurationProperties(prefix = "aliyun.mts")
public class AliMtsConfig
{

    //-----------------------------------------------------------------------------------------

    private boolean     useinter;
    private boolean     usehttps;
    private String      region;
    private AliAccount  account;
    private PipeLine    pipeline;
    private Transcode   transcode;
    private Watermark   watermark;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class PipeLine
    {
        private String id;
        private String name;
    }

    @Getter
    @Setter
    public static class Transcode
    {
        private String tplid;
        private String tplname;
        private long timeout;
        private String type; //mp4,m3u8
        private String videoCodec; //H.264
        private String videoBitrate; //1500
        private String videoWidth; //1280
        private String videoFps; //25
        private String audioCodec; //AAC
        private String audioBitrate; //128
    }

    @Getter
    @Setter
    public static class Watermark
    {
        private String tplid;
        private String tplname;
        private long timeout;
        private String width;
        private String dx;
        private String dy;
        private String referPos;
        private String fontSize;
        private String fontColor;
        private String fontAlpha;
        private String fontLeft;
        private String fontTop;
    }

    //-----------------------------------------------------------------------------------------

}
