/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.mts.message.OssTranscodeOutput:20190102173834
 *
 * OssTranscodeOutput.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.mts.message;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-02 17:38
 * @modify.date     2019-01-02 17:38
 */
@Setter
@Getter
@NoArgsConstructor
public class OssTranscodeOutput
{

    //-----------------------------------------------------------------------------------------

    private String TemplateId;
    private String OutputObject;
    private Container Container;
    private Video Video;
    private Audio Audio;

    //-----------------------------------------------------------------------------------------

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Container
    {
        private String Format; //mp4, m3u8
    }

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Video
    {
        private String Codec; //H.264
        private String Bitrate; //1500
        private String Width; //1280
        private String Fps; //25
    }

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Audio
    {
        private String Codec; //AAC
        private String Bitrate; //128
        private String Channels; //2
        private String Samplerate; //44100
    }

    //-----------------------------------------------------------------------------------------

}
