/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.mts.message.OssWatermarkOutput:20190102210649
 *
 * OssWatermarkOutput.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.mts.message;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-02 17:38
 * @modify.date     2019-01-02 17:38
 */
@Setter
@Getter
@NoArgsConstructor
public class OssWatermarkOutput
{

    //-----------------------------------------------------------------------------------------

    private String TemplateId;
    private String OutputObject;
    private List<WaterMark> WaterMarks;

    //-----------------------------------------------------------------------------------------

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class WaterMark
    {
        private String WaterMarkTemplateId;
        private String Type; //Image Text

        //Image Video
        private OssFile InputFile;
        //水印的位置,见ReferPos枚举类,若设置，则此值覆盖水印模板对应参数
        private String ReferPos; //TopRight BottomLeft
        // 水印图片宽高，若设置，则此值覆盖水印模板对应参数；
        // 值有两种形式：整数型代水印图片宽的像素值，范围[8,4096]，单位px；
        // 小数型代表相对输出视频分辨率宽的比率，范围(0,1),支持4位小数，如0.9999，超出部分系统自动丢弃
        private String Width; //0.05
        private String Height; //240
        // 水印图片相对输出视频的水平垂直偏移量，若设置，则此值覆盖水印模板对应参数,默认值是0；
        // 值有两种形式：整数型代表偏移像素，范围[0,4096]，单位px；
        // 小数型代表水平偏移量与输出分辨率宽的比率，范围(0,1),支持4位小数，如0.9999，超出部分系统自动丢弃
        private String Dx; //0
        private String Dy; //0

        //Text
        private TextWaterMark TextWaterMark; //

        //Image & Video
        public WaterMark(String tplid, OssFile input, String pos, String width, String height, String dx, String dy)
        {
            WaterMarkTemplateId = tplid;
            Type = "Image";
            InputFile = input;
            ReferPos = pos;
            Width = width;
            Height = height;
            Dx = dx;
            Dy = dy;
        }

        //Text
        public WaterMark(String tplid, TextWaterMark textwm)
        {
            WaterMarkTemplateId = tplid;
            Type = "Text";
            TextWaterMark = textwm;
        }
    }


    //-----------------------------------------------------------------------------------------

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TextWaterMark
    {
        private String Content; //
        private String FontName; //SimSun
        private String FontSize; //16
        private String FontColor; //Red
        private String FontAlpha; //0.5
        private String Top; //10
        private String Left; //10
    }

    //-----------------------------------------------------------------------------------------

}
