/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.oss.AliOssConfig:20181228180443
 *
 * AliOssConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.oss;

import cc.zuv.service.aliyun.AliAccount;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-28 18:04
 * @modify.date     2018-12-28 18:04
 */
@Getter
@Setter
@Configuration
@ConditionalOnProperty(name = "aliyun.oss.enabled", havingValue = "true")
//@ConditionalOnProperty(value = "aliyun.oss.enabled", matchIfMissing = false)
//@ConditionalOnProperty(name = "zuvboot.dfsloader.type", havingValue = "ALIOSS")
@ConfigurationProperties(prefix = "aliyun.oss")
public class AliOssConfig
{

    //-----------------------------------------------------------------------------------------

    private boolean             usehttps;  //是否使用HTTPS
    private boolean             useinter;  //是否使用内部地址
    private AliAccount          account;
    private Map<String, Bucket> buckets;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Bucket
    {
        private String name;
        private String memo;
        private String region;
        private String cdn;
        private boolean usecdn;
        private boolean protect;

    }

    //-----------------------------------------------------------------------------------------

}
