/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.search.AliSearchConfig:20190102113356
 *
 * AliSearchConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.search;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-02 11:33
 * @modify.date     2019-01-02 11:33
 */
@Getter
@Setter
@Configuration
@ConditionalOnProperty(name = "aliyun.search.enabled", havingValue = "true")
//@ConditionalOnProperty(value = "aliyun.search.enabled", matchIfMissing = false)
@ConfigurationProperties(prefix = "aliyun.search")
public class AliSearchConfig
{

//-----------------------------------------------------------------------------------------

    private String host;
    private int connectTimeout;
    private int timeout;
    private String version;
    private int maxConnections;
    private Account account;
    private Map<String, Instance> instances;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Account
    {
        private String key;
        private String secret;
    }

    @Getter
    @Setter
    public static class Instance
    {
        private String index;
        private String table;
    }

    //-----------------------------------------------------------------------------------------

}
