/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.cache.CacheConfig:20190315111612
 *
 * CacheConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.cache;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Method;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-15 11:16
 * @modify.date     2019-03-15 11:16
 */
@Configuration
public class CacheConfig
{

    //-----------------------------------------------------------------------------------------

    @Bean
    @ConditionalOnProperty(name = "spring.cache.keygen.enabled", havingValue = "true")
    public KeyGenerator keyGenerator()
    {
        return new KeyGenerator()
        {
            @Override
            public Object generate(Object target, Method method, Object... params)
            {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName());
                sb.append(method.getName());
                for (Object obj : params)
                {
                    sb.append(obj.toString());
                }
                return sb.toString();
            }
        };
    }

    //-----------------------------------------------------------------------------------------


}
