/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.cache.CacheService:20190103215746
 *
 * CacheService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.cache;

import cc.zuv.utility.KeyGenUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

/**
 * 缓存服务
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
@Component
public class CacheService
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private CacheManager cacheManager;

    //-----------------------------------------------------------------------------------------

    public boolean exists(String cache, Object key)
    {
        return cacheManager.getCache(cache).get(key)!=null;
    }

    public void del(String cache, Object key)
    {
        cacheManager.getCache(cache).evict(key);
    }

    public void set(String cache, Object key, Object value)
    {
        cacheManager.getCache(cache).put(key, value);
    }

    public void setnx(String cache, Object key, Object value)
    {
        cacheManager.getCache(cache).putIfAbsent(key, value);
    }

    public <T> T get(String cache, Object key, Class<T> type)
    {
        return cacheManager.getCache(cache).get(key, type);
    }

    public long incr(String cache, Object key)
    {
        long curr = cacheManager.getCache(cache).get(key, Long.TYPE);
        cacheManager.getCache(cache).put(key, ++curr);
        return curr;
    }

    public long decr(String cache, Object key)
    {
        long curr = cacheManager.getCache(cache).get(key, Long.TYPE);
        cacheManager.getCache(cache).put(key, --curr);
        return curr;
    }

    //-----------------------------------------------------------------------------------------

    // set max.value.sysuser 10

    /**
     * 根据规则生成递增编码
     * @param cachename 缓存名称
     * @param cachekey 缓存键名
     * @param keylen 编码长度
     * @param prefix 编码前缀
     * @return 编码
     */
    public synchronized String nextCode(String cachename, String cachekey, int keylen, String prefix)
    {
        long max = incr(cachename, cachekey);
        String cur = prefix!=null?KeyGenUtils.generate(keylen, prefix, max):KeyGenUtils.generate(keylen, max);
        log.debug("nextCode : " + cur);
        return cur;
    }

    //-----------------------------------------------------------------------------------------


}
