/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.cache.l1cache.Layer1CacheConfig:20190103215513
 *
 * Layer1CacheConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.cache.l1cache;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 一级缓存(内存缓存)
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Configuration
@ConditionalOnProperty(name = "spring.cache.l1cache.enabled", havingValue = "true")
public class Layer1CacheConfig
{

    //-----------------------------------------------------------------------------------------

    @Bean
    public CacheManager cacheManager()
    {
        return new ConcurrentMapCacheManager();
    }

    //-----------------------------------------------------------------------------------------

    /*
    private ConcurrentMap<String, Cache> CACHES = new ConcurrentHashMap<>();

    @Override
    public Cache getCache(String cachename)
    {
        Cache cache = CACHES.get(cachename);
        if(cache==null)
        {
            cache = new MapCache(cachename);
            CACHES.put(cachename, cache);
        }
        return cache;
    }

    @Override
    public Collection<String> getCacheNames()
    {
        return CACHES.keySet();
    }

    //-----------------------------------------------------------------------------------------

    public class MapCache implements Cache
    {

        //-----------------------------------------------------------------------------------------

        private ConcurrentMap<Object, Object> data = new ConcurrentHashMap<>();
        private String name;

        //-----------------------------------------------------------------------------------------

        public MapCache(String name)
        {
            this.name = name;
        }

        //-----------------------------------------------------------------------------------------

        @Override
        public String getName()
        {
            return name;
        }

        @Override
        public Object getNativeCache()
        {
            return null;
        }

        @Override
        public ValueWrapper get(Object o)
        {
            return null;
        }

        @Override
        public <T> T get(Object o, Class<T> aClass)
        {
            return null;
        }

        @Override
        public <T> T get(Object o, Callable<T> callable)
        {
            return null;
        }

        @Override
        public void put(Object key, Object value)
        {
            data.put(key, value);
        }

        @Override
        public ValueWrapper putIfAbsent(Object o, Object o1)
        {
            return null;
        }

        @Override
        public void evict(Object key)
        {
            data.remove(key);
        }

        @Override
        public void clear()
        {
            data.clear();
        }

    }*/

    //-----------------------------------------------------------------------------------------

}
