/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.cache.l2cache.Layer2CacheConfig:20190102110433
 *
 * Layer2CacheConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.cache.l2cache;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

/**
 * 两级缓存(内存缓存+Ehcache)
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Configuration
@ConditionalOnProperty(name = "spring.cache.l2cache.enabled", havingValue = "true")
public class Layer2CacheConfig
{

    //-----------------------------------------------------------------------------------------

    @Bean("ehCacheManager")
    public EhCacheCacheManager ehCacheCacheManager()
    {
        net.sf.ehcache.CacheManager object = ehCacheManagerFactoryBean().getObject();
        EhCacheCacheManager ehCacheCacheManager = new EhCacheCacheManager(object);
        return ehCacheCacheManager;
    }

    public EhCacheManagerFactoryBean ehCacheManagerFactoryBean()
    {
        EhCacheManagerFactoryBean cacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        cacheManagerFactoryBean.setConfigLocation(new ClassPathResource("ehcache.xml"));
        cacheManagerFactoryBean.setShared(true);
        return cacheManagerFactoryBean;
    }

    //-----------------------------------------------------------------------------------------

}
