/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.cache.l3cache.Layer3CacheConfig:20190102110420
 *
 * Layer3CacheConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.cache.l3cache;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 三级缓存(内存缓存+Ehcache+Redis)
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Configuration
@ConditionalOnProperty(name = "spring.cache.l3cache.enabled", havingValue = "true")
public class Layer3CacheConfig
{

    //-----------------------------------------------------------------------------------------

    @Bean("ehCacheManager")
    public EhCacheCacheManager ehCacheCacheManager()
    {
        net.sf.ehcache.CacheManager object = ehCacheManagerFactoryBean().getObject();
        EhCacheCacheManager ehCacheCacheManager = new EhCacheCacheManager(object);
        return ehCacheCacheManager;
    }

    @Bean
    public EhCacheManagerFactoryBean ehCacheManagerFactoryBean()
    {
        EhCacheManagerFactoryBean cacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        cacheManagerFactoryBean.setConfigLocation(new ClassPathResource("ehcache.xml"));
        cacheManagerFactoryBean.setShared(true);
        return cacheManagerFactoryBean;
    }

    //-----------------------------------------------------------------------------------------

//    @ConditionalOnProperty(value = "spring.redis.enabled", havingValue="true")
//    @ConditionalOnExpression("${spring.redis.enabled:true}")
    @Bean("redisCacheManager")
    public RedisCacheManager redisCacheManager(RedisTemplate<String, Object> redisTemplate)
    {
        RedisCacheManager cacheManager = new RedisCacheManager(redisTemplate);
        cacheManager.setDefaultExpiration(60 * 60);
        return cacheManager;
    }

    //-----------------------------------------------------------------------------------------

//    @ConditionalOnExpression("'${spring.redis.enabled}'=='true'")
//    @ConditionalOnProperty(name="spring.lycache.layer", havingValue="l2")
//    @ConditionalOnExpression("${spring.redis.enabled:true}")
    @Bean("cacheManager")
    @Primary
    public CacheManager initMixCacheManager(EhCacheCacheManager ehCacheManager, RedisCacheManager redisCacheManager)
    {
        Layer3CacheManager cacheManager = new Layer3CacheManager();
        cacheManager.setEhCacheCacheManager(ehCacheManager);
        cacheManager.setRedisCacheManager(redisCacheManager);
        return cacheManager;
    }

    //-----------------------------------------------------------------------------------------

}
