/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.cache.l3cache.Layer3CacheManager:20190102110420
 *
 * Layer3CacheManager.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.cache.l3cache;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;

/**
 * 三级缓存管理器
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Component
@ConditionalOnProperty(name = "spring.cache.l3cache.enabled", havingValue = "true")
public class Layer3CacheManager implements CacheManager
{

    //-----------------------------------------------------------------------------------------

    private EhCacheCacheManager ehCacheManager;
    private RedisCacheManager redisCacheManager;

    //-----------------------------------------------------------------------------------------

    @Override
    public Cache getCache(String name)
    {
        Cache cache = ehCacheManager.getCache(name);
        if(cache!=null)
        {
            return cache;
        }
        if(redisCacheManager!=null)
        {
            return redisCacheManager.getCache(name);
        }
        return null;


        /*if (name.startsWith("redis"))
        {
            return redisCacheManager.getCache(name);
        }
        else
        {
            return ehCacheManager.getCache(name);
        }*/
    }

    @Override
    public Collection<String> getCacheNames()
    {
        Collection<String> cacheNames = new ArrayList<>();
        cacheNames.addAll(ehCacheManager.getCacheNames());
        if (redisCacheManager != null)
        {
            cacheNames.addAll(redisCacheManager.getCacheNames());
        }
        return cacheNames;
    }

    //-----------------------------------------------------------------------------------------

    public EhCacheCacheManager getEhCacheCacheManager()
    {
        return ehCacheManager;
    }

    public void setEhCacheCacheManager(EhCacheCacheManager ehcacheCacheManager)
    {
        this.ehCacheManager = ehcacheCacheManager;
    }

    public RedisCacheManager getRedisCacheManager()
    {
        return redisCacheManager;
    }

    public void setRedisCacheManager(RedisCacheManager redisCacheManager)
    {
        this.redisCacheManager = redisCacheManager;
    }

    //-----------------------------------------------------------------------------------------
}
