/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.coder.CoderService:20190121152044
 *
 * CoderService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.coder;

import cc.zuv.utility.HashIdsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-21 15:20
 * @modify.date     2019-01-21 15:20
 */
@Slf4j
@Component
public class CoderService
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private CoderConfig coderConfig;

    //-----------------------------------------------------------------------------------------

    private HashIdsUtils helper;

    private HashIdsUtils getHelper()
    {
        if(helper==null)
        {
            helper = new HashIdsUtils(coderConfig.getSalt(), coderConfig.getMinHashLength());
        }
        return helper;
    }

    //-----------------------------------------------------------------------------------------

    public String hashIdsEncode(long... nums)
    {
        return getHelper().encode(nums);
    }

    public long[] hashIdsDecode(String hash)
    {
        return getHelper().decode(hash);
    }

    //-----------------------------------------------------------------------------------------

}
