/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.mailer.IMailerService:20181225151549
 *
 * IMailerService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.mailer;


import java.io.File;
import java.io.InputStream;
import java.net.URL;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
public interface IMailerService
{

    //-----------------------------------------------------------------------------------------

    boolean sendText(String to, String subject, String content);
    boolean sendText(String[] tos, String subject, String content);
    boolean sendText(String[] tos, String[] ccs, String[] bccs, String subject, String content);

    boolean sendText(String from, String to, String subject, String content);
    boolean sendText(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content);

    //-----------------------------------------------------------------------------------------

    boolean sendHtml(String to, String subject, String content);
    boolean sendHtml(String[] tos, String subject, String content);
    boolean sendHtml(String[] tos, String[] ccs, String[] bccs, String subject, String content);

    boolean sendHtml(String from, String to, String subject, String content);
    boolean sendHtml(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content);

    //-----------------------------------------------------------------------------------------

    boolean sendHtmlWithInline(String to, String subject, String content, String cid, File file);
    boolean sendHtmlWithInline(String[] tos, String subject, String content, String cid, File file);
    boolean sendHtmlWithInline(String from, String to, String subject, String content, String cid, File file);
    boolean sendHtmlWithInline(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content, String cid, File file);

    boolean sendHtmlWithInline(String to, String subject, String content, String cid, URL attachurl);
    boolean sendHtmlWithInline(String[] tos, String subject, String content, String cid, URL attachurl);
    boolean sendHtmlWithInline(String from, String to, String subject, String content, String cid, URL attachurl);
    boolean sendHtmlWithInline(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content, String cid, URL attachurl);

    boolean sendHtmlWithInline(String to, String subject, String content, String cid, InputStream stream);
    boolean sendHtmlWithInline(String[] tos, String subject, String content, String cid, InputStream stream);
    boolean sendHtmlWithInline(String from, String to, String subject, String content, String cid, InputStream stream);
    boolean sendHtmlWithInline(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content, String cid, InputStream stream);

    //-----------------------------------------------------------------------------------------

    boolean sendHtmlWithAttach(String to, String subject, String content, File file);
    boolean sendHtmlWithAttach(String[] tos, String subject, String content, File file);
    boolean sendHtmlWithAttach(String from, String to, String subject, String content, File file);
    boolean sendHtmlWithAttach(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content, File file);

    boolean sendHtmlWithAttach(String to, String subject, String content, String attachname, URL attachurl);
    boolean sendHtmlWithAttach(String[] tos, String subject, String content, String attachname, URL attachurl);
    boolean sendHtmlWithAttach(String from, String to, String subject, String content, String attachname, URL attachurl);
    boolean sendHtmlWithAttach(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content, String attachname, URL attachurl);

    boolean sendHtmlWithAttach(String to, String subject, String content, String attachname, InputStream stream);
    boolean sendHtmlWithAttach(String[] tos, String subject, String content, String attachname, InputStream stream);
    boolean sendHtmlWithAttach(String from, String to, String subject, String content, String attachname, InputStream stream);
    boolean sendHtmlWithAttach(String from, String[] tos, String[] ccs, String[] bccs, String subject, String content, String attachname, InputStream stream);

    //-----------------------------------------------------------------------------------------

}
