/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.office.libreoffice.LibreOfficeConfig:20190124170951
 *
 * LibreOfficeConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.office.libreoffice;

import org.jodconverter.DocumentConverter;
import org.jodconverter.LocalConverter;
import org.jodconverter.office.OfficeManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * zuv-cloud File Description
 *
 * $ tar zxvf LibreOffice_6.0.7_Linux_x86-64_rpm.tar.gz
 * $ sudo yum install ./LibreOffice_6.0.7.3_Linux_x86-64_rpm/RPMS/*.rpm
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-24 17:09
 * @modify.date     2019-01-24 17:09
 */
@Configuration
@ConditionalOnProperty(name="jodconverter.enabled", havingValue = "true")
public class LibreOfficeConfig
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private OfficeManager officeManager;

    @Bean
    public DocumentConverter documentConverter()
    {
        return LocalConverter.builder()
            .officeManager(officeManager)
            .build();
    }

    //-----------------------------------------------------------------------------------------

}
