/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.office.libreoffice.LibreOfficeService:20190124171334
 *
 * LibreOfficeService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.office.libreoffice;

import cc.zuv.ZuvException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.jodconverter.DocumentConverter;
import org.jodconverter.document.DefaultDocumentFormatRegistry;
import org.jodconverter.office.OfficeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-01-24 17:13
 * @modify.date     2019-01-24 17:13
 */
@Slf4j
@Component
@ConditionalOnProperty(name="jodconverter.enabled", havingValue = "true")
public class LibreOfficeService
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private DocumentConverter documentConverter;

    //-----------------------------------------------------------------------------------------

    public void docx2pdf(File source, File target)
    {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try
        {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);

            documentConverter
                .convert(fis)
                .as(DefaultDocumentFormatRegistry.DOCX)
                .to(fos)
                .as(DefaultDocumentFormatRegistry.PDF)
                .execute();
        }
        catch (OfficeException | IOException e)
        {
            log.error("转换文档错误 {}", e.getMessage());
            throw new ZuvException("转换文档错误", e);
        }
        finally
        {
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(fis);
        }
    }

    //-----------------------------------------------------------------------------------------

}
