/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.office.onlyoffice.OnlyOfficeUtility:20190102105533
 *
 * OnlyOfficeUtility.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.office.onlyoffice;

import cc.zuv.lang.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
public class OnlyOfficeUtility
{

    //-----------------------------------------------------------------------------------------

    public static String ProcessConvertServiceResponceError(int errorCode)
    {
        String errorMessage = "";
        String errorMessageTemplate = "Error occurred in the ConvertService: ";

        switch (errorCode)
        {
            case -8:
                errorMessage = errorMessageTemplate + "Error document VKey";
                break;
            case -7:
                errorMessage = errorMessageTemplate + "Error document request";
                break;
            case -6:
                errorMessage = errorMessageTemplate + "Error database";
                break;
            case -5:
                errorMessage = errorMessageTemplate + "Error unexpected guid";
                break;
            case -4:
                errorMessage = errorMessageTemplate + "Error download error";
                break;
            case -3:
                errorMessage = errorMessageTemplate + "Error convertation error";
                break;
            case -2:
                errorMessage = errorMessageTemplate + "Error convertation timeout";
                break;
            case -1:
                errorMessage = errorMessageTemplate + "Error convertation unknown";
                break;
            case 0:
                break;
            default:
                errorMessage = "ErrorCode = " + errorCode;
                break;
        }

        return errorMessage;
//        throw new Exception(errorMessage);
    }


    //-----------------------------------------------------------------------------------------

    public static String GenerateRevisionId(String expectedKey)
    {
        if (expectedKey.length() > 20)
            expectedKey = Integer.toString(expectedKey.hashCode());

        String key = expectedKey.replace("[^0-9-.a-zA-Z_=]", "_");

        return key.substring(0, Math.min(key.length(), 20));
    }

    //-----------------------------------------------------------------------------------------

    public static String GetInternalExtension(String fileType)
    {
        if(fileType.equals("spreadsheet"))
            return ".xlsx";

        if(fileType.equals("presentation"))
            return ".pptx";

        return ".docx";
    }

    public static String GetDocumentType(String fileName)
    {
        String ext = StringUtils.getFileExt(fileName, true);

        if (ExtsDocument.contains(ext))
            return "text";

        if (ExtsSpreadsheet.contains(ext))
            return "spreadsheet";

        if (ExtsPresentation.contains(ext))
            return "presentation";

        return "text";
    }

    public static List<String> ExtsDocument = Arrays.asList
        (
            ".doc", ".docx", ".docm", ".dot", ".dotx", ".dotm",
            ".odt", ".fodt", ".rtf", ".txt", ".html", ".htm",
            ".mht", ".pdf", ".djvu", ".fb2", ".epub", ".xps"
        );

    public static List<String> ExtsSpreadsheet = Arrays.asList
        (
            ".xls", ".xlsx", ".xlsm", ".xlt", ".xltx", ".xltm",
            ".ods", ".fods", ".csv"
        );

    public static List<String> ExtsPresentation = Arrays.asList
        (
            ".pps", ".ppsx", ".ppsm", ".ppt", ".pptx", ".pptm",
            ".pot", ".potx", ".potm", ".odp", ".fodp"
        );

    //-----------------------------------------------------------------------------------------

}
