/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.pusher.Handler:20190325180402
 *
 * Handler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.pusher;

import cc.zuv.collections.CollectionUtils;
import cc.zuv.service.pusher.getui.GeTuiParser;
import cc.zuv.service.pusher.huanx.*;
import cc.zuv.service.pusher.huanx.message.ChatRoomResponse;
import cc.zuv.service.pusher.huanx.message.ChatRoomsResponse;
import cc.zuv.service.pusher.huanx.message.UserResponse;
import cc.zuv.service.pusher.huanx.message.UsersResponse;
import cc.zuv.service.pusher.jpush.JPushParser;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-25 18:04
 * @modify.date     2019-03-25 18:04
 */
@Slf4j
public final class PusherHandler implements IPusher
{

    //-----------------------------------------------------------------------------------------

    public void setGetui(GeTuiParser parser)
    {
        this.getui = parser;
    }

    public void setJpush(JPushParser parser)
    {
        this.jpush = parser;
    }

    public void setHuanxin(HuanXinParser parser)
    {
        this.huanxin = parser;
    }

    //-----------------------------------------------------------------------------------------

    private GeTuiParser     getui;  //个推
    private JPushParser     jpush;  //极光
    private HuanXinParser   huanxin;//环信

    //-----------------------------------------------------------------------------------------

    public PusherHandler()
    {
    }

    public PusherHandler(JPushParser jpush)
    {
        this.jpush = jpush;
    }

    public PusherHandler(GeTuiParser getui)
    {
        this.getui = getui;
    }

    public PusherHandler(HuanXinParser huanxin)
    {
        this.huanxin = huanxin;
    }

    //-----------------------------------------------------------------------------------------
    // 个推
    //-------------------------------------------------------------------------------------------

    public String getui_getalias(String devcode)
    {
        return getui.getClientAlias(devcode);
    }

    public boolean getui_bindalias(String devcode, String usercode)
    {
        return getui.bindClientAlias(devcode, usercode);
    }

    public boolean getui_unbindalias(String devcode, String usercode)
    {
        return getui.unbindClientAlias(devcode, usercode);
    }

    public List<String> getui_getdevcodes(String usercode)
    {
        return getui.getClientIdsByAlias(usercode);
    }

    public boolean getui_unbindaliasall(String usercode)
    {
        return getui.unbindAliasAll(usercode);
    }

    //-----------------------------------------------------------------------------------------

    public String[] getui_gettags(String devcode)
    {
        return getui.getClientTags(devcode);
    }

    public boolean getui_settags(String devcode, String... tags)
    {
        return getui.setClientTags(devcode, tags);
    }

    //-----------------------------------------------------------------------------------------

    public boolean getui_getonline(String devcode)
    {
        return getui.getClientStatusOnline(devcode);
    }

    //-----------------------------------------------------------------------------------------

    public boolean getui_setbadge(String badge, String... devcodes)
    {
        return getui.setIOSClientBadge(badge, devcodes);
    }

    //-----------------------------------------------------------------------------------------

    public String getui_send_devcode_transmission(Map<String, Object> extra, String... devcodes)
    {
        if(extra==null) extra = new TreeMap<>();
        String tcontent = new Gson().toJson(extra);
        return getui_send_devcode_transmission(tcontent, devcodes);
    }

    public String getui_send_devcode_transmission(String tcontent, String... devcodes)
    {
        if(devcodes==null || devcodes.length==0) return null;
        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return devcodes.length>1?getui.sendToClientIds(data, devcodes):getui.sendToClientId(data, devcodes[0]);
    }

    public String getui_send_devcode_link(String url, String title, String content, String logourl, boolean apns, String... devcodes)
    {
        if(devcodes==null || devcodes.length==0) return null;

        LinkTemplate data =  getui.getLinkTemplate(url, title, content, logourl);
        ITemplate apnspayload = getui.bldAPNPayload(data, title, content);

        if(devcodes.length>1)
        {
            return apns ? getui.sendToClientIds(apnspayload, devcodes) : getui.sendToClientIds(data, devcodes);
        }
        else
        {
            return apns ? getui.sendToClientId(apnspayload, devcodes[0]) : getui.sendToClientId(data, devcodes[0]);
        }
    }

    public String getui_send_devcode_notification(Map<String, Object> extra, String title, String content, String logourl, boolean apns, String... devcodes)
    {
        if(extra==null) extra = new TreeMap<>();
        String tcontent = new Gson().toJson(extra);
        return getui_send_devcode_notification(tcontent, title, content, logourl, apns, devcodes);
    }

    public String getui_send_devcode_notification(String tcontent, String title, String content, String logourl, boolean apns, String... devcodes)
    {
        if(devcodes==null || devcodes.length==0) return null;

        NotificationTemplate data = getui.getNotificationTemplate(title, content, logourl, true, tcontent);
        ITemplate apnspayload = getui.bldAPNPayload(data, title, content);

        if(devcodes.length>1)
        {
            return apns ? getui.sendToClientIds(apnspayload, devcodes) : getui.sendToClientIds(data, devcodes);
        }
        else
        {
            return apns ? getui.sendToClientId(apnspayload, devcodes[0]) : getui.sendToClientId(data, devcodes[0]);
        }
    }

    //-----------------------------------------------------------------------------------------

    public String getui_send_alias_transmission(Map<String, Object> extra, String... aliases)
    {
        if(extra==null) extra = new TreeMap<>();
        String tcontent = new Gson().toJson(extra);
        return getui_send_alias_transmission(tcontent, aliases);
    }

    public String getui_send_alias_transmission(String tcontent, String... aliases)
    {
        if(aliases==null || aliases.length==0) return null;

        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return aliases.length>1?getui.sendToAliases(data, aliases):getui.sendToAlias(data, aliases[0]);
    }

    public String getui_send_alias_link(String url, String title, String content, String logourl, boolean apns, String... aliases)
    {
        if(aliases==null || aliases.length==0) return null;

        LinkTemplate data =  getui.getLinkTemplate(url, title, content, logourl);
        ITemplate apnspayload = getui.bldAPNPayload(data, title, content);

        if(aliases.length>1)
        {
            return apns ? getui.sendToAliases(apnspayload, aliases) : getui.sendToAliases(data, aliases);
        }
        else
        {
            return apns ? getui.sendToAlias(apnspayload, aliases[0]) : getui.sendToAlias(data, aliases[0]);
        }
    }

    public String getui_send_alias_notification(Map<String, Object> extra, String title, String content, String logourl, boolean apns, String... aliases)
    {
        if(extra==null) extra = new TreeMap<>();
        String tcontent = new Gson().toJson(extra);

        return getui_send_alias_notification(tcontent, title, content, logourl, apns, aliases);
    }

    public String getui_send_alias_notification(String tcontent, String title, String content, String logourl, boolean apns, String... aliases)
    {
        if(aliases==null || aliases.length==0) return null;

        NotificationTemplate data = getui.getNotificationTemplate(title, content, logourl, true, tcontent);
        ITemplate apnspayload = getui.bldAPNPayload(data, title, content);

        if(aliases.length>1)
        {
            return apns ? getui.sendToAliases(apnspayload, aliases) : getui.sendToAliases(data, aliases);
        }
        else
        {
            return apns ? getui.sendToAlias(apnspayload, aliases[0]) : getui.sendToAlias(data, aliases[0]);
        }
    }

    //-----------------------------------------------------------------------------------------

    public String getui_send_app_transmission(Map<String, Object> extra, String... tags)
    {
        if(extra==null) extra = new TreeMap<>();
        String tcontent = new Gson().toJson(extra);

        return getui_send_app_transmission(tcontent, tags);
    }

    public String getui_send_app_transmission(String tcontent, String... tags)
    {
        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return getui.sendToApp(data, tags);
    }

    public String getui_send_app_link(String url, String title, String content, String logourl, boolean apns, String... tags)
    {
        LinkTemplate data =  getui.getLinkTemplate(url, title, content, logourl);
        ITemplate apnspayload = getui.bldAPNPayload(data, title, content);
        return apns ? getui.sendToApp(apnspayload, tags) : getui.sendToApp(data, tags);
    }

    public String getui_send_app_notification(Map<String, Object> extra, String title, String content, String logourl, boolean apns, String... tags)
    {
        if(extra==null) extra = new TreeMap<>();
        String tcontent = new Gson().toJson(extra);

        return getui_send_app_notification(tcontent, title, content, logourl, apns, tags);
    }

    public String getui_send_app_notification(String tcontent, String title, String content, String logourl, boolean apns, String... tags)
    {
        NotificationTemplate data = getui.getNotificationTemplate(title, content, logourl, true, tcontent);
        ITemplate apnspayload = getui.bldAPNPayload(data, title, content);
        return apns ? getui.sendToApp(apnspayload, tags) : getui.sendToApp(data, tags);
    }

    //-----------------------------------------------------------------------------------------

    public String getui_send_region_transmission(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, String regioncode, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);
        String tcontent = new Gson().toJson(extra);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_RGNS + regioncode);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return getui.sendToApp(data, tags);
    }

    public String getui_send_group_transmission(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, long groupid, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);
        String tcontent = new Gson().toJson(extra);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_GRPS + groupid);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return getui.sendToApp(data, tags);
    }

    public String getui_send_org_transmission(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, long orgid, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);
        String tcontent = new Gson().toJson(extra);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_ORGS + orgid);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return getui.sendToApp(data, tags);
    }

    public String getui_send_dept_transmission(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, long deptid, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);
        String tcontent = new Gson().toJson(extra);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_DEPT + deptid);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        TransmissionTemplate data = getui.getTransmissionTemplate(true, tcontent);
        return getui.sendToApp(data, tags);
    }

    //-----------------------------------------------------------------------------------------






    //-----------------------------------------------------------------------------------------
    // 极光
    //-------------------------------------------------------------------------------------------

    public String jpush_getalias(String devcode)
    {
        return jpush.get_alias(devcode);
    }

    public boolean jpush_setalias(String devcode, String usercode)
    {
        return jpush.set_alias(devcode, usercode);
    }

    public List<String> jpush_gettags(String devcode)
    {
        return jpush.get_tags(devcode);
    }

    public boolean jpush_settags(String devcode, String... tags)
    {
        return jpush.set_tags(devcode, tags);
    }

    public boolean jpush_addtag(String devcode, String tag)
    {
        return jpush.add_tag(devcode, tag);
    }

    public boolean jpush_deltag(String devcode, String tag)
    {
        return jpush.del_tag(devcode, tag);
    }

    public boolean jpush_clear_alias_tags(String devcode)
    {
        return jpush.clear_alias_tags(devcode);
    }

    //-----------------------------------------------------------------------------------------

    public boolean jpush_get_user_onlinestatus(String devcode)
    {
        return jpush.get_user_onlinestatus(devcode);
    }

    //-----------------------------------------------------------------------------------------

    public String jpush_get_message_report(String msgid)
    {
        return jpush.get_message_report(msgid);
    }

    //-----------------------------------------------------------------------------------------

    public long jpush_send_notification_all(String title)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_notification(audience, title);
        return jpush.send(payload);
    }

    public String jpush_send_notification_all(String title, String time, String taskname)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_notification(audience, title);
        return jpush.send(payload, time, taskname);
    }

    public long jpush_send_notification_alias(String title, String... alias)
    {
        Audience audience = jpush.audience_alias(alias);
        PushPayload payload = jpush.build_notification(audience, title);
        return jpush.send(payload);
    }

    public long jpush_send_notification_tags_or(String title, String... tags)
    {
        Audience audience = jpush.audience_tags_or(tags);
        PushPayload payload = jpush.build_notification(audience, title);
        return jpush.send(payload);
    }

    public long jpush_send_notification_tags_and(String title, String... tags)
    {
        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_notification(audience, title);
        return jpush.send(payload);
    }

    public long jpush_send_notification_devcode(String title, String... devcodes)
    {
        Audience audience = jpush.audience_regid(devcodes);
        PushPayload payload = jpush.build_notification(audience, title);
        return jpush.send(payload);
    }

    //-----------------------------------------------------------------------------------------

    public long jpush_send_message_all(String title, String content, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_message(audience, content, title, extra);
        return jpush.send(payload);
    }

    public long jpush_send_message_alias(String title, String content, Map<String, String> extra, String... alias)
    {
        Audience audience = jpush.audience_alias(alias);
        PushPayload payload = jpush.build_message(audience, content, title, extra);
        return jpush.send(payload);
    }

    public long jpush_send_message_tags_or(String title, String content, Map<String, String> extra, String... tags)
    {
        Audience audience = jpush.audience_tags_or(tags);
        PushPayload payload = jpush.build_message(audience, content, title, extra);
        return jpush.send(payload);
    }

    public long jpush_send_message_tags_and(String title, String content, Map<String, String> extra, String... tags)
    {
        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_message(audience, content, title, extra);
        return jpush.send(payload);
    }

    public long jpush_send_message_devcode(String title, String content, Map<String, String> extra, String... devcodes)
    {
        Audience audience = jpush.audience_regid(devcodes);
        PushPayload payload = jpush.build_message(audience, content, title, extra);
        return jpush.send(payload);
    }

    //-----------------------------------------------------------------------------------------

    public long jpush_send_android_notification_all(String title, String content, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_android_notification(audience, content, title, extra);
        return jpush.send(payload);
    }

    public long jpush_send_ios_notification_all(String title, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_ios_notification(audience, title, extra);
        return jpush.send(payload);
    }

    public long jpush_send_android_ios_notification_all(String title, String content, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_android_ios_notification(audience, content, title, extra);
        return jpush.send(payload);
    }

    //-----------------------------------------------------------------------------------------

    public long jpush_send_android_all(String title, String content, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_android(audience, content, title, content, extra);
        return jpush.send(payload);
    }

    public long jpush_send_ios_all(String title, String content, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_ios(audience, content, title, content, extra);
        return jpush.send(payload);
    }

    public long jpush_send_android_ios_all(String title, String content, Map<String, String> extra)
    {
        Audience audience = jpush.audience_all();
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_android_ios_alias(String title, String content, Map<String, String> extra, String... alias)
    {
        Audience audience = jpush.audience_alias(alias);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_android_ios_tags_or(String title, String content, Map<String, String> extra, String... tags)
    {
        Audience audience = jpush.audience_tags_or(tags);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_android_ios_tags_and(String title, String content, Map<String, String> extra, String... tags)
    {
        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_android_ios_devcode(String title, String content, Map<String, String> extra, String... devcodes)
    {
        Audience audience = jpush.audience_regid(devcodes);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    //-----------------------------------------------------------------------------------------

    public long jpush_send_region(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, String regioncode, String title, String content, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_RGNS + regioncode);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_group(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, long groupid, String title, String content, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_GRPS + groupid);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_org(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, long orgid, String title, String content, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_ORGS + orgid);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    public long jpush_send_dept(String appcode, int msgtype, String module, String channel, String scheme, int termtype, int usertype, long deptid, String title, String content, Map<String, String> extra)
    {
        if(extra==null) extra = new TreeMap<>();
        extra.put(PUSHER_EXTRAS_TAG_APPCODE, appcode);
        extra.put(PUSHER_EXTRAS_TAG_MSGTYPE, String.valueOf(msgtype));
        extra.put(PUSHER_EXTRAS_TAG_MODULE, module);
        extra.put(PUSHER_EXTRAS_TAG_CHANNEL, channel);
        extra.put(PUSHER_EXTRAS_TAG_SCHEME, scheme);

        List<String> list = new ArrayList<>();
        list.add(PUSHER_TAG_PRE_DEPT + deptid);
        if(usertype>0) list.add(PUSHER_TAG_PRE_USERTYPE + usertype);
        if(termtype>0) list.add(PUSHER_TAG_PRE_TERMINAL + termtype);
        String[] tags = CollectionUtils.toArray(String.class, list);

        Audience audience = jpush.audience_tags_and(tags);
        PushPayload payload = jpush.build_android_ios(audience, content, title, content, extra, false, true);
        return jpush.send(payload);
    }

    //-------------------------------------------------------------------------------------------



    //-----------------------------------------------------------------------------------------
    // 环信
    //-----------------------------------------------------------------------------------------

    public boolean huanxin_adduser(String usercode, String userpass, String username)
    {
        UserResponse res = huanxin.parser_user_add(usercode, userpass, username);
        return res!=null;
    }

    public boolean huanxin_deluser(String usercode)
    {
        UserResponse res = huanxin.parser_user_del(usercode);
        return res!=null;
    }

    public void huanxin_getuser(String usercode)
    {
        UserResponse res = huanxin.parser_user(usercode);
        log.info(res.action);
    }

    public void huanxin_getusers()
    {
        UsersResponse res = huanxin.parser_users(20, null);
        log.info(res.action);
    }

    public void huanxin_getuserstatus(String usercode)
    {
        UserResponse res = huanxin.parser_user_status(usercode);
        log.info(res.action);
    }

    public boolean huanxin_chguserpass(String usercode, String newpass)
    {
        UserResponse res = huanxin.parser_user_chgpass(usercode, newpass);
        return res!=null;
    }

    public boolean huanxin_chgusername(String usercode, String username)
    {
        UserResponse res = huanxin.parser_user_chgnick(usercode, username);
        return res!=null;
    }

    //-------------------------------------------------------------------------------------------

    public String huanxin_addchat(String usercode, String name, String desc, int maxu)
    {
        ChatRoomResponse res = huanxin.parser_chatroom_create(usercode, name, desc, maxu);
        if(res!=null && res.data!=null && res.data.containsKey("id"))
        {
            return (String)res.data.get("id");
        }

        return null;
    }

    public boolean huanxin_chgchat(String chatroomid, String name, String desc, int maxu)
    {
        ChatRoomResponse res = huanxin.parser_chatroom_update(chatroomid, name, desc, maxu);
        if(res!=null && res.data!=null)
        {
            boolean namedone = (Boolean)res.data.get("name");
            boolean descdone = (Boolean)res.data.get("description");
            boolean maxudone = (Boolean)res.data.get("maxusers");
            return namedone && descdone && maxudone;
        }

        return false;
    }

    public boolean huanxin_delchat(String chatroomid)
    {
        ChatRoomResponse res = huanxin.parser_chatroom_delete(chatroomid);
        if(res!=null && res.data!=null)
        {
            return (Boolean)res.data.get("success");
        }

        return false;
    }

    public void huanxin_getchat(String chatroomid)
    {
        ChatRoomResponse res = huanxin.parser_chatroom(chatroomid);
        if(res!=null && res.data!=null)
        {
            log.info("id=" + res.data.get("id"));
            log.info("name=" + res.data.get("name"));
        }
    }

    public void huanxin_getchats()
    {
        ChatRoomsResponse res = huanxin.parser_chatrooms();
        if(res!=null && res.data!=null)
        {
            log.info("size : " + res.data.size());
        }
    }

    //-------------------------------------------------------------------------------------------


}
