/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.pusher.condition.HuanXinCondition:20190326180249
 *
 * HuanXinCondition.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.pusher.condition;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-26 18:00
 * @modify.date     2019-03-26 18:00
 */
public class HuanXinCondition implements Condition
{

    //-----------------------------------------------------------------------------------------

    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata)
    {
        String enabled = conditionContext.getEnvironment().getProperty("zuvboot.push.enabled");
        String type = conditionContext.getEnvironment().getProperty("zuvboot.push.type");
        return "true".equalsIgnoreCase(enabled) && type!=null && type.contains("huanxin");
    }

    //-----------------------------------------------------------------------------------------

}
