/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.pusher.getui.GeTuiConfig:20190328103857
 *
 * GeTuiConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.pusher.getui;

import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-28 10:38
 * @modify.date     2019-03-28 10:38
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "zuvboot.push.getui.enabled", havingValue = "true")
@EnableConfigurationProperties(GeTuiProperties.class)
public class GeTuiConfig
{

    //-----------------------------------------------------------------------------------------

    private static Map<String, GeTuiParser> services = Maps.newHashMap();

    public static GeTuiParser getParser(String appid)
    {
        GeTuiParser parser = services.get(appid);
        if (parser == null)
        {
            throw new IllegalArgumentException(String.format("未找到对应appid=[%s]的配置，请核实！", appid));
        }
        return parser;
    }

    //-----------------------------------------------------------------------------------------

    @Autowired
    private GeTuiProperties properties;

    @PostConstruct
    public void initParsers()
    {
        for(GeTuiProperties.Config c : properties.getConfigs())
        {
            String url = c.getUrl();
            String appid = c.getAppid();
            String appkey = c.getAppkey();
            String mastersecret = c.getMastersecret();
            services.put(appid, new GeTuiParser(url, appid, appkey, mastersecret));
        }
        log.info("init getui");
    }

    //-----------------------------------------------------------------------------------------

}
