/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.pusher.huanx.HuanXinConfig:20190328111249
 *
 * HuanXinConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.pusher.huanx;

import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-28 10:38
 * @modify.date     2019-03-28 10:38
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "zuvboot.push.huanxin.enabled", havingValue = "true")
@EnableConfigurationProperties(HuanXinProperties.class)
public class HuanXinConfig
{

    //-----------------------------------------------------------------------------------------

    private static Map<String, HuanXinParser> services = Maps.newHashMap();

    public static HuanXinParser getParser(String clientid)
    {
        HuanXinParser parser = services.get(clientid);
        if (parser == null)
        {
            throw new IllegalArgumentException(String.format("未找到对应clientid=[%s]的配置，请核实！", clientid));
        }
        return parser;
    }

    //-----------------------------------------------------------------------------------------

    @Autowired
    private HuanXinProperties properties;

    @PostConstruct
    public void initParsers()
    {
        for(HuanXinProperties.Config c : properties.getConfigs())
        {
            String url = c.getUrl();
            String orgname = c.getOrgname();
            String appname = c.getAppname();
            String clientid = c.getClientid();
            String clientsecret = c.getClientsecret();
            boolean production = c.isProduction();
            services.put(clientid, new HuanXinParser(url, orgname, appname, clientid, clientsecret, production));
        }
        log.info("init huanxin");
    }

    //-----------------------------------------------------------------------------------------

}
