/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.pusher.huanx.HuanXinProperties:20190328110806
 *
 * HuanXinProperties.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.pusher.huanx;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-28 10:31
 * @modify.date     2019-03-28 10:31
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "zuvboot.push.huanxin")
public class HuanXinProperties
{

    //-----------------------------------------------------------------------------------------

    private List<Config> configs;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Config
    {

        private String  url;
        private String  orgname;
        private String  appname;
        private String  clientid;
        private String  clientsecret;
        private boolean production;

    }

    //-----------------------------------------------------------------------------------------

}
