/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.pusher.jpush.JPushConfig:20190328110031
 *
 * JPushConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.pusher.jpush;

import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-03-28 10:38
 * @modify.date     2019-03-28 10:38
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "zuvboot.push.jpush.enabled", havingValue = "true")
@EnableConfigurationProperties(JPushProperties.class)
public class JPushConfig
{

    //-----------------------------------------------------------------------------------------

    private static Map<String, JPushParser> services = Maps.newHashMap();

    public static JPushParser getParser(String appkey)
    {
        JPushParser parser = services.get(appkey);
        if (parser == null)
        {
            throw new IllegalArgumentException(String.format("未找到对应appkey=[%s]的配置，请核实！", appkey));
        }
        return parser;
    }

    //-----------------------------------------------------------------------------------------

    @Autowired
    private JPushProperties properties;

    @PostConstruct
    public void initParsers()
    {
        for(JPushProperties.Config c : properties.getConfigs())
        {
            String appkey = c.getAppkey();
            String mastersecret = c.getMastersecret();
            int maxretrytimes = c.getMaxretrytimes();
            boolean production = c.isProduction();

            services.put(appkey, new JPushParser(appkey, mastersecret, maxretrytimes, production));
        }
        log.info("init jpush");
    }

    //-----------------------------------------------------------------------------------------

}
