/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.smser.condition.AlismsCondition:20190222164501
 *
 * AlismsCondition.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.smser.condition;

import cc.zuv.service.smser.SmserType;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-22 16:16
 * @modify.date     2019-02-22 16:16
 */
public class AlismsCondition implements Condition
{

    //-----------------------------------------------------------------------------------------

    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata)
    {
        String enabled = conditionContext.getEnvironment().getProperty("zuvboot.sms.enabled");
        String type = conditionContext.getEnvironment().getProperty("zuvboot.sms.type");
        return "true".equalsIgnoreCase(enabled) && SmserType.alisms.name().equalsIgnoreCase(type);
    }

    //-----------------------------------------------------------------------------------------

}
