/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.spider.lucene.SpiderIndexer:20181225151549
 *
 * SpiderIndexer.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */
package cc.zuv.service.spider.lucene;

import cc.zuv.service.spider.ISpiderCode;
import cc.zuv.service.spider.ISpiderDocument;
import lombok.extern.slf4j.Slf4j;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.*;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexWriterConfig.OpenMode;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

import java.io.File;
import java.io.IOException;

/**
 * File Description
 *
 * @author			Kama Luther
 * @version			0.1
 * @since           0.1
 * @create.date     2014-2-11 下午02:19:48
 * @modify.date     2014-2-11 下午02:19:48
 */
@Slf4j
public class SpiderIndexer implements ISpiderCode
{

    //-----------------------------------------------------------------------------------------

	private File indexDirectory;
    private Analyzer analyzer;
    protected IndexWriter FSDWriter; //存储于磁盘
    protected IndexWriter RAMWriter; //存储于内存

	public SpiderIndexer(String indexerpath, SpiderParser parser)
	{
		//
		indexDirectory = new File(indexerpath);
    	if(!indexDirectory.exists()) indexDirectory.mkdirs();

    	//
		analyzer = parser.getAnalyzer();
	}

    //-----------------------------------------------------------------------------------------

	public boolean index(ISpiderDocument idoc)
	{
		Document document = serialize(idoc);
		return write(document, idoc.getCatalog(), idoc.getIdentity());
	}

    //-----------------------------------------------------------------------------------------

    private Document serialize(ISpiderDocument idoc)
    {
        Document doc = new Document();
		doc.add(new StringField(KEY_IDENTITY, idoc.getCatalog()+"-"+idoc.getIdentity(), Field.Store.YES));
		doc.add(new StringField(KEY_URLER, idoc.getUrler(), Field.Store.YES));
		doc.add(new StringField(KEY_TITLE, idoc.getTitle(), Field.Store.YES));
		doc.add(new TextField(KEY_CONTENT, idoc.getContent(), Field.Store.YES));
		doc.add(new LongField(KEY_MODIFIED, idoc.getModified(), Field.Store.YES));
        return doc;
    }

    private boolean write(Document doc, int catalog, String identity)
    {
    	try
		{
	    	//
	    	IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_46, analyzer);
	    	iwc.setOpenMode(OpenMode.CREATE_OR_APPEND);
//	    	iwc.setRAMBufferSizeMB(256.0);

	    	Directory dir = FSDirectory.open(indexDirectory);
			FSDWriter = new IndexWriter(dir, iwc);
			FSDWriter.addDocument(doc);
			FSDWriter.updateDocument(new Term(KEY_IDENTITY, catalog+"-"+identity), doc);
			FSDWriter.close();

			return true;
		}
		catch (IOException e)
		{
			log.error("IO Error", e);
			return false;
		}
    }

    //-----------------------------------------------------------------------------------------

}
