/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.storage.dfs.IDfsService:20181230002748
 *
 * IDfsService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.storage.dfs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-29 11:49
 * @modify.date     2018-12-29 11:49
 */
public interface IDfsService
{

    //-----------------------------------------------------------------------------------------

    //
    public static final String FILE_META_FILEKEY  = "FileKey";
    public static final String FILE_META_FILENAME = "FileName";
    public static final String FILE_META_FILESIZE = "FileSize";
    public static final String FILE_META_FILEMIME = "FileMime";
    public static final String FILE_META_FILEHASH = "FileHash";
    public static final String FILE_META_FILEETAG = "FileEtag";
    public static final String FILE_META_FILEDATE = "FileDate";
    public static final String FILE_META_FILEKIND = "FileKind";
    public static final String FILE_META_FORMNAME = "FormName";
    public static final String FILE_META_ORIGNAME = "OrigName";

    //-----------------------------------------------------------------------------------------

    void initial();
    void destroy();

    //-----------------------------------------------------------------------------------------

    //切换存储目标位置
    void setBucketKey(String bucketkey);

    //-----------------------------------------------------------------------------------------

    //上传(保存文件到dfs)
    boolean upload(String targetpath, File sourcefile, Map<String, String> meta);
    boolean upload(String targetpath, InputStream sourceis, Map<String, String> meta);

    //-----------------------------------------------------------------------------------------

    //下载(从dfs读取文件)
    boolean download(String sourcepath, File targetfile);
    boolean download(String sourcepath, OutputStream targetos);

    //-----------------------------------------------------------------------------------------

    //是否存在
    boolean exist(String sourcepath);

    //-----------------------------------------------------------------------------------------

    //移动
    boolean movefile(String sourcepath, String targetpath);

    //拷贝
    boolean copyfold(String sourcefold, String targetfold);
    boolean copyfile(String sourcepath, String targetpath);

    //-----------------------------------------------------------------------------------------

    //创建目录
    boolean mkfold(String sourcefold);

    //删除
    boolean rmfold(String sourcefold);
    boolean rmfile(String sourcepath);

    //遍历目录
    List<Map<String, Object>> lsfold(String sourcefold);

    //-----------------------------------------------------------------------------------------

    //查询文件信息
    Map<String, Object> filemeta(String sourcepath);

    //查询文件摘要
    String filehash(String sourcepath);

    //查询文件修改时间
    long filedate(String sourcepath);

    //查询文件大小
    long filesize(String sourcepath);

    //-----------------------------------------------------------------------------------------

    //查询文件物理路径
    String phypath(String sourcepath);

    //查询文件访问路径
    String fileuri(String sourcepath);

    //-----------------------------------------------------------------------------------------

}
