/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.storage.dfs.condition.FastdfCondition:20190501123502
 *
 * FastdfCondition.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.storage.dfs.condition;

import cc.zuv.service.storage.dfs.DfsType;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-22 16:16
 * @modify.date     2019-02-22 16:16
 */
public class FastdfCondition implements Condition
{

    //-----------------------------------------------------------------------------------------

    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata)
    {
        String enabled = conditionContext.getEnvironment().getProperty("zuvboot.dfsloader.enabled");
        String type = conditionContext.getEnvironment().getProperty("zuvboot.dfsloader.type");
        return "true".equalsIgnoreCase(enabled) && DfsType.FASTDF.name().equalsIgnoreCase(type);
    }

    //-----------------------------------------------------------------------------------------

}
