/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.storage.dfs.impl.LocalDfsConfig:20190501114637
 *
 * LocalDfsConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.storage.dfs.local;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-05-01 11:46
 * @modify.date     2019-05-01 11:46
 */
@Getter
@Setter
@Configuration
@ConditionalOnProperty(name = "zuvboot.dfsloader.type", havingValue = "LOCAL")
@ConfigurationProperties(prefix = "zuvboot.dfsloader.local")
public class LocalDfsConfig
{

    //-----------------------------------------------------------------------------------------

    private Map<String, Bucket> buckets;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Bucket
    {
        private String mapping;
        private String phypath;
    }

    //-----------------------------------------------------------------------------------------

}
