/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.storage.smb.SMBConnector:20181225151549
 *
 * SMBConnector.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.storage.smb;

import cc.zuv.ZuvException;
import jcifs.Config;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileInputStream;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-21 21:08
 * @modify.date     2018-12-21 21:08
 */
@Slf4j
public class SMBConnector
{

    //-----------------------------------------------------------------------------------------

    public SMBConnector connect(String domain, String account, String password)
    {
        Config.registerSmbURLHandler();
        Config.setProperty("jcifs.smb.client.domain", domain);
        Config.setProperty("jcifs.smb.client.username", account);
        Config.setProperty("jcifs.smb.client.password", password);
        return this;
    }

    public SmbFile[] list(String path, SmbFileFilter filter)
    {
        try
        {
            SmbFile smbfile = new SmbFile(path);
            if(smbfile.isDirectory())
            {
                return (filter!=null)?smbfile.listFiles(filter):smbfile.listFiles();
            }
            else
            {
                return new SmbFile[]{smbfile};
            }
        }
        catch (MalformedURLException e)
        {
            log.error("语法错误 {}", e.getMessage());
            throw new ZuvException("语法错误", e);
        }
        catch (SmbException e)
        {
            log.error("读取错误 {}", e.getMessage());
            throw new ZuvException("读取错误", e);
        }
    }

    public int save(SmbFile source, File target)
    {
        int copy;
        try
        {
            copy = IOUtils.copy(new SmbFileInputStream(source), new FileOutputStream(target));
            log.info("copy {}", copy);
        }
        catch (IOException e)
        {
            log.error("读写错误 {}", e.getMessage());
            throw new ZuvException("读写错误", e);
        }
        return copy;
    }

    //-----------------------------------------------------------------------------------------


}
