/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxapp.config.WechatAppConfig:20190211114455
 *
 * WechatAppConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxapp.config;

import cc.zuv.service.wechat.wxapp.handler.*;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-11 11:44
 * @modify.date     2019-02-11 11:44
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "wechat.wxapp.enabled", havingValue = "true")
@EnableConfigurationProperties(WechatAppProperties.class)
public class WechatAppConfig
{

    //-----------------------------------------------------------------------------------------

    private static Map<String, WxMaMessageRouter> routers = Maps.newHashMap();
    private static Map<String, WxMaService> services = Maps.newHashMap();


    public static Map<String, WxMaMessageRouter> getRouters()
    {
        return routers;
    }

    public static WxMaService getMaService(String appid)
    {
        WxMaService wxService = services.get(appid);
        if (wxService == null)
        {
            throw new IllegalArgumentException(String.format("未找到对应appid=[%s]的配置，请核实！", appid));
        }
        return wxService;
    }

    //-----------------------------------------------------------------------------------------

    @Autowired
    private MaLogHandler maLogHandler;

    @Autowired
    private MaTplHandler maTplHandler;

    @Autowired
    private MaTextHandler maTextHandler;

    @Autowired
    private MaPicHandler maPicHandler;

    @Autowired
    private MaQrcHandler maQrcHandler;

    //-----------------------------------------------------------------------------------------

    @Autowired
    private WechatAppProperties properties;

    @PostConstruct
    public void initServices()
    {
        for(WechatAppProperties.Config c : properties.getConfigs())
        {
            String appid = c.getAppId();
            WxMaInMemoryConfig config = new WxMaInMemoryConfig();
            config.setAppid(appid);
            config.setSecret(c.getSecret());
            config.setToken(c.getToken());
            config.setAesKey(c.getAesKey());
            config.setMsgDataFormat(c.getMsgFormat());

            WxMaService service = new WxMaServiceImpl();
            service.setWxMaConfig(config);
            services.put(appid, service);
            routers.put(appid, newRouter(service));
        }
        log.info("init services");
    }

    private WxMaMessageRouter newRouter(WxMaService service)
    {
        final WxMaMessageRouter router = new WxMaMessageRouter(service);
        router
            .rule().handler(maLogHandler).next()
            .rule().async(false).content("模板").handler(maTplHandler).end()
            .rule().async(false).content("文本").handler(maTextHandler).end()
            .rule().async(false).content("图片").handler(maPicHandler).end()
            .rule().async(false).content("二维码").handler(maQrcHandler).end();
        return router;
    }

    //-----------------------------------------------------------------------------------------

}
