/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxapp.config.WechatAppProperties:20190211115255
 *
 * WechatAppProperties.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxapp.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-11 11:52
 * @modify.date     2019-02-11 11:52
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "wechat.wxapp")
public class WechatAppProperties
{

    //-----------------------------------------------------------------------------------------

    private List<Config> configs;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Config
    {
        /**
         * 设置微信小程序的appid
         */
        private String appId;

        /**
         * 设置微信小程序的Secret
         */
        private String secret;

        /**
         * 设置微信小程序消息服务器配置的token
         */
        private String token;

        /**
         * 设置微信小程序消息服务器配置的EncodingAESKey
         */
        private String aesKey;

        /**
         * 消息格式，XML或者JSON
         */
        private String msgFormat;
    }

    //-----------------------------------------------------------------------------------------

}
