/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxapp.handler.MaLogHandler:20190213100607
 *
 * MaLogHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxapp.handler;

import cc.zuv.service.wechat.wxapp.builder.TextBuilder;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaKefuMessage;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-13 10:06
 * @modify.date     2019-02-13 10:06
 */
@Slf4j
@Component
public class MaLogHandler implements WxMaMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public void handle(
        WxMaMessage message,
        Map<String, Object> context,
        WxMaService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        String msgtxt = "收到消息: " + message.toString();
        WxMaKefuMessage builder = new TextBuilder().build(msgtxt, message, service);
        service.getMsgService().sendKefuMsg(builder);
    }

    //-----------------------------------------------------------------------------------------

}
