/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxapp.handler.MaQrcHandler:20190213101311
 *
 * MaQrcHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxapp.handler;

import cc.zuv.service.wechat.wxapp.builder.ImageBuilder;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaKefuMessage;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-13 10:06
 * @modify.date     2019-02-13 10:06
 */
@Slf4j
@Component
public class MaQrcHandler implements WxMaMessageHandler
{

    //-----------------------------------------------------------------------------------------

    String code = "123";
    int width = 430;

    //-----------------------------------------------------------------------------------------

    @Override
    public void handle(
        WxMaMessage message,
        Map<String, Object> context,
        WxMaService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        try
        {
            final File file = service.getQrcodeService().createQrcode(code, width);
            WxMediaUploadResult uploadResult = service.getMediaService().uploadMedia("image", file);

            WxMaKefuMessage builder = new ImageBuilder().build(uploadResult.getMediaId(), message, service);
            service.getMsgService().sendKefuMsg(builder);
        }
        catch (WxErrorException e)
        {
            log.error("handleMessage Error {}", e.getMessage());
        }
    }

    //-----------------------------------------------------------------------------------------

}
