/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxapp.handler.MaTplHandler:20190213101047
 *
 * MaTplHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxapp.handler;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaKefuMessage;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateData;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateMessage;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-13 10:06
 * @modify.date     2019-02-13 10:06
 */
@Slf4j
@Component
public class MaTplHandler implements WxMaMessageHandler
{

    //-----------------------------------------------------------------------------------------

    String templateid = "0"; // 此处更换为自己的模板id
    String formid = "0"; //自己替换可用的formid

    //-----------------------------------------------------------------------------------------

    @Override
    public void handle(
        WxMaMessage message,
        Map<String, Object> context,
        WxMaService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        WxMaTemplateMessage builder = WxMaTemplateMessage.builder()
            .templateId(templateid)
            .formId(formid)
            .data(Lists.newArrayList(new WxMaTemplateData("keyword1", "339208499", "#173177")))
            .toUser(message.getFromUser())
            .build();
        service.getMsgService().sendTemplateMsg(builder);
    }

    //-----------------------------------------------------------------------------------------

}
