/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxapp.service.WechatAppService:20190211152121
 *
 * WechatAppService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxapp.service;

import cc.zuv.ZuvException;
import cc.zuv.service.wechat.wxapp.config.WechatAppConfig;
import cc.zuv.service.wechat.wxapp.persist.WxAppJsSession;
import cc.zuv.service.wechat.wxapp.persist.WxAppMedia;
import cc.zuv.service.wechat.wxapp.persist.WxAppPhoneInfo;
import cc.zuv.service.wechat.wxapp.persist.WxAppUserInfo;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.constant.WxMaConstants;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.stereotype.Service;

import java.io.File;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-11 15:21
 * @modify.date     2019-02-11 15:21
 */
@Slf4j
@Service
public class WechatAppService
{

    //-----------------------------------------------------------------------------------------

    public WxAppJsSession getSessionInfo(String appid, String code)
    {
        final WxMaService wxService = WechatAppConfig.getMaService(appid);
        try
        {
            WxMaJscode2SessionResult session = wxService.getUserService().getSessionInfo(code);

            WxAppJsSession jsSession = new WxAppJsSession();
            jsSession.setSessionkey(session.getSessionKey());
            jsSession.setOpenid(session.getOpenid());
            jsSession.setUnionid(session.getUnionid());
            return jsSession;
        }
        catch (WxErrorException e)
        {
            log.error("getSessionInfo Error {}", e.getMessage());
            throw new ZuvException("getSessionInfo Error", e);
        }
    }

    public WxAppUserInfo getUserInfo(String appid,
                                     String sessionKey, String signature,
                                     String rawData, String encryptedData, String iv)
    {
        final WxMaService wxService = WechatAppConfig.getMaService(appid);

        // 用户信息校验
        if (!wxService.getUserService().checkUserInfo(sessionKey, rawData, signature))
        {
            log.error("checkUserInfo Error");
            throw new ZuvException("checkUserInfo Error");
        }

        // 解密用户信息
        WxMaUserInfo userInfo = wxService.getUserService().getUserInfo(sessionKey, encryptedData, iv);

        //
        WxAppUserInfo appUserInfo = new WxAppUserInfo();
        appUserInfo.setOpenid(userInfo.getOpenId());
        appUserInfo.setUnionid(userInfo.getUnionId());
        appUserInfo.setNickname(userInfo.getNickName());
        appUserInfo.setAvatarurl(userInfo.getAvatarUrl());
        appUserInfo.setCountry(userInfo.getCountry());
        appUserInfo.setProvince(userInfo.getProvince());
        appUserInfo.setCity(userInfo.getCity());
        appUserInfo.setGender(userInfo.getGender());
        appUserInfo.setLanguage(userInfo.getLanguage());
        return appUserInfo;
    }

    public WxAppPhoneInfo getPhoneInfo(String appid,
                                       String sessionKey, String signature,
                                       String rawData, String encryptedData, String iv)
    {
        final WxMaService wxService = WechatAppConfig.getMaService(appid);

        // 用户信息校验
        if (!wxService.getUserService().checkUserInfo(sessionKey, rawData, signature))
        {
            log.error("checkUserInfo Error");
            throw new ZuvException("checkUserInfo Error");
        }

        // 解密用户信息
        WxMaPhoneNumberInfo phoneInfo = wxService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);

        //
        WxAppPhoneInfo appPhoneInfo = new WxAppPhoneInfo();
        appPhoneInfo.setCountrycode(phoneInfo.getCountryCode());
        appPhoneInfo.setPhonenumber(phoneInfo.getPhoneNumber());
        appPhoneInfo.setPurephonenumber(phoneInfo.getPurePhoneNumber());
        return appPhoneInfo;
    }

    //-----------------------------------------------------------------------------------------

    public WxAppMedia uploadMedia(String appid, File file)
    {
        final WxMaService wxService = WechatAppConfig.getMaService(appid);
        try
        {
            WxMediaUploadResult uploadResult = wxService.getMediaService().uploadMedia(WxMaConstants.KefuMsgType.IMAGE, file);

            WxAppMedia media = new WxAppMedia();
            media.setMediaid(uploadResult.getMediaId());
            media.setThumbmediaid(uploadResult.getThumbMediaId());
            media.setType(uploadResult.getType());
            media.setUrl(uploadResult.getUrl());
            media.setCreatedat(uploadResult.getCreatedAt());
            return media;
        }
        catch (WxErrorException e)
        {
            log.error("uploadMedia Error {}", e.getMessage());
            throw new ZuvException("uploadMedia Error", e);
        }
    }

    public File getMedia(String appid, String mediaid)
    {
        final WxMaService wxService = WechatAppConfig.getMaService(appid);
        try
        {
            return wxService.getMediaService().getMedia(mediaid);
        }
        catch (WxErrorException e)
        {
            log.error("getMedia Error {}", e.getMessage());
            throw new ZuvException("getMedia Error", e);
        }
    }

    //-----------------------------------------------------------------------------------------

}
