/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxcp.builder.ImageBuilder:20190214115302
 *
 * ImageBuilder.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxcp.builder;

import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutMessage;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:57
 * @modify.date     2019-02-12 15:57
 */
public class ImageBuilder extends AbstractBuilder
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxCpXmlOutMessage build(String content, WxCpXmlMessage message, WxCpService service)
    {
        return WxCpXmlOutMessage.IMAGE()
            .mediaId(content)
            .fromUser(message.getToUserName())
            .toUser(message.getFromUserName())
            .build();
    }

    //-----------------------------------------------------------------------------------------

}
