/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxcp.handler.McLocationHandler:20190214154353
 *
 * McLocationHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxcp.handler;

import cc.zuv.service.wechat.wxcp.builder.TextBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.message.WxCpMessageHandler;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-14 15:05
 * @modify.date     2019-02-14 15:05
 */
@Slf4j
@Component
public class McLocationHandler implements WxCpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxCpXmlOutMessage handle(
        WxCpXmlMessage message,
        Map<String, Object> context,
        WxCpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        //
        if (message.getMsgType().equals(WxConsts.XmlMsgType.LOCATION))
        {
            //TODO 接收处理用户发送的地理位置消息
            try
            {
                String content = "感谢反馈，您的的地理位置已收到！";
                return new TextBuilder().build(content, message, service);
            }
            catch (Exception e)
            {
                log.error(e.getMessage(), e);
                return null;
            }
        }

        //上报地理位置事件
        log.info("\n上报地理位置，纬度 : {}\n经度 : {}\n精度 : {}",
            message.getLatitude(), message.getLongitude(), message.getPrecision());

        //TODO  可以将用户地理位置信息保存到本地数据库，以便以后使用

        return null;
    }

    //-----------------------------------------------------------------------------------------

}
