/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxcp.handler.McSubscribeHandler:20190214164354
 *
 * McSubscribeHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxcp.handler;

import cc.zuv.service.wechat.wxcp.builder.TextBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.bean.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.message.WxCpMessageHandler;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-14 15:05
 * @modify.date     2019-02-14 15:05
 */
@Slf4j
@Component
public class McSubscribeHandler implements WxCpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxCpXmlOutMessage handle(
        WxCpXmlMessage message,
        Map<String, Object> context,
        WxCpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        // 获取微信用户基本信息
        String openid = message.getFromUserName();
        log.info("新关注用户 OPENID: {}", openid);
        WxCpUser userWxInfo = service.getUserService().getById(openid);

        if (userWxInfo != null)
        {
            // TODO 可以添加关注用户到本地
        }

        WxCpXmlOutMessage responseResult = null;
        try
        {
            responseResult = handleSpecial(message);
        }
        catch (Exception e)
        {
            log.error(e.getMessage(), e);
        }

        if (responseResult != null)
        {
            return responseResult;
        }

        try
        {
            return new TextBuilder().build("感谢关注", message, service);
        }
        catch (Exception e)
        {
            log.error(e.getMessage(), e);
        }

        return null;
    }

    /**
     * 处理特殊请求，比如如果是扫码进来的，可以做相应处理
     */
    private WxCpXmlOutMessage handleSpecial(WxCpXmlMessage message)
    {
        //TODO
        return null;
    }

    //-----------------------------------------------------------------------------------------

}
