/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxcp.handler.McUnsubscribeHandler:20190214165238
 *
 * McUnsubscribeHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxcp.handler;

import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.message.WxCpMessageHandler;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-14 15:05
 * @modify.date     2019-02-14 15:05
 */
@Slf4j
@Component
public class McUnsubscribeHandler implements WxCpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxCpXmlOutMessage handle(
        WxCpXmlMessage message,
        Map<String, Object> context,
        WxCpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        String openid = message.getFromUserName();
        log.info("取消关注用户 OPENID: {}", openid);
        // TODO 可以更新本地数据库为取消关注状态
        return null;
    }

    //-----------------------------------------------------------------------------------------

}
