/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.config.WechatMpProperties:20190212150804
 *
 * WechatMpProperties.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:08
 * @modify.date     2019-02-12 15:08
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "wechat.wxmp")
public class WechatMpProperties
{

    //-----------------------------------------------------------------------------------------

    private List<Config> configs;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Config
    {
        /**
         * 设置微信公众号的appid
         */
        private String appId;

        /**
         * 设置微信公众号的app secret
         */
        private String secret;

        /**
         * 设置微信公众号的token
         */
        private String token;

        /**
         * 设置微信公众号的EncodingAESKey
         */
        private String aesKey;
    }

    //-----------------------------------------------------------------------------------------

}
