/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.handler.MpLocationHandler:20190212154017
 *
 * MpLocationHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.handler;

import cc.zuv.service.wechat.wxmp.builder.TextBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.stereotype.Component;

import java.util.Map;

import static me.chanjar.weixin.common.api.WxConsts.XmlMsgType;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:33
 * @modify.date     2019-02-12 15:33
 */
@Slf4j
@Component
public class MpLocationHandler implements WxMpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxMpXmlOutMessage handle(
        WxMpXmlMessage message,
        Map<String, Object> context,
        WxMpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        //接收用户发送的地理位置消息
        if (message.getMsgType().equals(XmlMsgType.LOCATION))
        {
            //TODO 接收处理用户发送的地理位置消息
            try
            {
                String content = "感谢反馈，您的的地理位置已收到！";
                return new TextBuilder().build(content, message, service);
            }
            catch (Exception e)
            {
                log.error("位置消息接收处理失败 {}", e.getMessage());
                return null;
            }
        }

        //上报地理位置事件
        log.info("上报地理位置，纬度 : {}，经度 : {}，精度 : {}",
            message.getLatitude(), message.getLongitude(), message.getPrecision());

        //TODO  可以将用户地理位置信息保存到本地数据库，以便以后使用
        return null;
    }

    //-----------------------------------------------------------------------------------------

}
