/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.handler.MenuHandler:20190212160426
 *
 * MenuHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.handler;

import cc.zuv.service.wechat.wxmp.builder.TextBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:33
 * @modify.date     2019-02-12 15:33
 */
@Slf4j
@Component
public class MpMenuHandler implements WxMpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxMpXmlOutMessage handle(
        WxMpXmlMessage message,
        Map<String, Object> context,
        WxMpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        String msgtxt = String.format("type:%s, event:%s, key:%s",
            message.getMsgType(), message.getEvent(), message.getEventKey());
        log.info("{}", msgtxt);

        if (WxConsts.MenuButtonType.VIEW.equals(message.getEvent()))
        {
            return null;
        }

        return new TextBuilder().build(msgtxt, message, service);
    }

    //-----------------------------------------------------------------------------------------

}
