/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.handler.MpMsgHandler:20190212161021
 *
 * MpMsgHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.handler;

import cc.zuv.service.wechat.wxmp.builder.TextBuilder;
import cc.zuv.service.wechat.wxmp.builder.TransferBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:33
 * @modify.date     2019-02-12 15:33
 */
@Slf4j
@Component
public class MpMsgHandler implements WxMpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    String[] keys = new String[]{"你好", "客服"}; //关键词如“你好”，“客服”等

    //-----------------------------------------------------------------------------------------

    @Override
    public WxMpXmlOutMessage handle(
        WxMpXmlMessage message,
        Map<String, Object> context,
        WxMpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        //
        if (!message.getMsgType().equals(WxConsts.XmlMsgType.EVENT))
        {
            //TODO 可以选择将消息保存到本地
        }

        //当用户输入关键词，并且有客服在线时，把消息转发给在线客服
        try
        {
            if (StringUtils.startsWithAny(message.getContent(), keys)
                && service.getKefuService().kfOnlineList().getKfOnlineList().size() > 0)
            {
                return new TransferBuilder().build(null, message, service);
            }
        }
        catch (WxErrorException e)
        {
            log.error(e.getMessage(), e);
        }

        //TODO 组装回复消息
        String content = "收到信息内容：" + message;
        return new TextBuilder().build(content, message, service);
    }

    //-----------------------------------------------------------------------------------------

}
