/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.handler.MpSubscribeHandler:20190212162746
 *
 * MpSubscribeHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.handler;

import cc.zuv.service.wechat.wxmp.builder.TextBuilder;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:33
 * @modify.date     2019-02-12 15:33
 */
@Slf4j
@Component
public class MpSubscribeHandler implements WxMpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxMpXmlOutMessage handle(
        WxMpXmlMessage message,
        Map<String, Object> context,
        WxMpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        // 获取微信用户基本信息
        try
        {
            String openid = message.getFromUser();
            log.info("新关注用户 OPENID: " + openid);

            WxMpUser user = service.getUserService().userInfo(openid, "zh_CN");
            if (user != null)
            {
                String nickname = user.getNickname();
                log.info("{}", nickname);
                // TODO 可以添加关注用户到本地数据库
            }
        }
        catch (WxErrorException e)
        {
            if (e.getError().getErrorCode() == 48001)
            {
                log.info("该公众号没有获取用户信息权限！");
            }
        }


        //
        WxMpXmlOutMessage responseResult = null;
        try
        {
            responseResult = this.handleSpecial(message);
        }
        catch (Exception e)
        {
            log.error(e.getMessage(), e);
        }

        if (responseResult != null)
        {
            return responseResult;
        }

        try
        {
            return new TextBuilder().build("感谢关注", message, service);
        }
        catch (Exception e)
        {
            log.error(e.getMessage(), e);
        }

        return null;
    }

    /**
     * 处理特殊请求，比如如果是扫码进来的，可以做相应处理
     */
    private WxMpXmlOutMessage handleSpecial(WxMpXmlMessage wxMessage)
        throws Exception
    {
        //TODO
        return null;
    }

    //-----------------------------------------------------------------------------------------

}
