/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.handler.MpUnsubscribeHandler:20190212163418
 *
 * MpUnsubscribeHandler.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.handler;

import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-12 15:33
 * @modify.date     2019-02-12 15:33
 */
@Slf4j
@Component
public class MpUnsubscribeHandler implements WxMpMessageHandler
{

    //-----------------------------------------------------------------------------------------

    @Override
    public WxMpXmlOutMessage handle(
        WxMpXmlMessage message,
        Map<String, Object> context,
        WxMpService service,
        WxSessionManager sessionManager)
        throws WxErrorException
    {
        log.debug("\n{}", message);

        //
        String openid = message.getFromUser();
        log.info("取消关注用户 OPENID: {}", openid);
        // TODO 可以更新本地数据库为取消关注状态

        return null;
    }

    //-----------------------------------------------------------------------------------------

}
