/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxmp.service.WxMpService:20190211093740
 *
 * WxMpService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxmp.service;

import cc.zuv.ZuvException;
import cc.zuv.service.wechat.wxmp.config.WechatMpConfig;
import cc.zuv.service.wechat.wxmp.persist.WxMpJsapiSign;
import cc.zuv.service.wechat.wxmp.persist.WxMpUserInfo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-11 09:37
 * @modify.date     2019-02-11 09:37
 */
@Slf4j
@Service
public class WechatMpService
{

    //-----------------------------------------------------------------------------------------

    /*
    获取重定向地址
     */
    public String redirectUri(String appid, String redirectUri, String state)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);
        return wxMpService.oauth2buildAuthorizationUrl(redirectUri, WxConsts.OAuth2Scope.SNSAPI_USERINFO, state);
    }

    /*
    查询用户信息
     */
    public WxMpUserInfo getUserInfoByCode(String appid, String code, String lang)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);
        try
        {
            WxMpOAuth2AccessToken accessToken = wxMpService.oauth2getAccessToken(code);
            WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(accessToken, lang);

            WxMpUserInfo userInfo = new WxMpUserInfo();
            userInfo.setOpenid(wxMpUser.getOpenId());
            userInfo.setUnionid(wxMpUser.getUnionId());
            userInfo.setNickname(wxMpUser.getNickname());
            userInfo.setHeadimgurl(wxMpUser.getHeadImgUrl());
            userInfo.setLanguage(wxMpUser.getLanguage());
            userInfo.setQrscene(wxMpUser.getQrSceneStr());
            userInfo.setGender(wxMpUser.getSexDesc());
            userInfo.setRemark(wxMpUser.getRemark());
            userInfo.setCountry(wxMpUser.getCountry());
            userInfo.setProvince(wxMpUser.getProvince());
            userInfo.setCity(wxMpUser.getCity());
            userInfo.setSubscribe(wxMpUser.getSubscribe());
            userInfo.setSubscribescene(wxMpUser.getSubscribeScene());
            userInfo.setSubscribetime(wxMpUser.getSubscribeTime());
            userInfo.setGroupid(wxMpUser.getGroupId());
            userInfo.setPrivileges(wxMpUser.getPrivileges());
            userInfo.setTagids(wxMpUser.getTagIds());
            return userInfo;
        }
        catch (WxErrorException e)
        {
            log.error("getUserInfoByCode Error {}", e.getMessage());
            throw new ZuvException("getUserInfoByCode Error", e);
        }
    }

    /*
    查询用户信息
     */
    public WxMpUserInfo getUserInfoById(String appid, String openid, String lang)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);
        try
        {
            WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openid, lang);

            WxMpUserInfo userInfo = new WxMpUserInfo();
            userInfo.setOpenid(wxMpUser.getOpenId());
            userInfo.setUnionid(wxMpUser.getUnionId());
            userInfo.setNickname(wxMpUser.getNickname());
            userInfo.setHeadimgurl(wxMpUser.getHeadImgUrl());
            userInfo.setLanguage(wxMpUser.getLanguage());
            userInfo.setQrscene(wxMpUser.getQrSceneStr());
            userInfo.setGender(wxMpUser.getSexDesc());
            userInfo.setRemark(wxMpUser.getRemark());
            userInfo.setCountry(wxMpUser.getCountry());
            userInfo.setProvince(wxMpUser.getProvince());
            userInfo.setCity(wxMpUser.getCity());
            userInfo.setSubscribe(wxMpUser.getSubscribe());
            userInfo.setSubscribescene(wxMpUser.getSubscribeScene());
            userInfo.setSubscribetime(wxMpUser.getSubscribeTime());
            userInfo.setGroupid(wxMpUser.getGroupId());
            userInfo.setPrivileges(wxMpUser.getPrivileges());
            userInfo.setTagids(wxMpUser.getTagIds());
            return userInfo;
        }
        catch (WxErrorException e)
        {
            log.error("getUserInfoById Error {}", e.getMessage());
            throw new ZuvException("getUserInfoByCode Error", e);
        }
    }

    /*
    获取Jsapi签名
     */
    public WxMpJsapiSign getJsapiSign(String appid, String http_refefer)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);

        try
        {
            String ticket = wxMpService.getJsapiTicket();
            WxJsapiSignature signature = wxMpService.createJsapiSignature(http_refefer);

            WxMpJsapiSign jsapiSign = new WxMpJsapiSign();
            jsapiSign.setAppid(appid);
            jsapiSign.setTicket(ticket);
            jsapiSign.setUrl(signature.getUrl());
            jsapiSign.setTimestamp(signature.getTimestamp());
            jsapiSign.setNoncestr(signature.getNonceStr());
            jsapiSign.setSignature(signature.getSignature());
            return jsapiSign;
        }
        catch (WxErrorException e)
        {
            log.error("getJsapiSign Error {}", e.getMessage());
            throw new ZuvException("getJsapiSign Error", e);
        }
    }

    //-----------------------------------------------------------------------------------------
    //模板消息
    //https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1433751277

    /**
     * 发送模板消息
     * @param appid 应用标识
     * @param openid 用户标识
     * @param tplid 模板标识
     * @param data 替换数据
     * @param url 跳转地址(可以拼接用户信息和业务信息)
     * @return 是否成功
     */
    public String sendTemplateMsg(String appid, String openid, String tplid, Map<String, String> data, String url)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);

        //
        WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
            .toUser(openid)    //推送用户
            .templateId(tplid)    //发送的消息模板ID
            .url(url)    //点击跳转路径
            .build();
        for(String key : data.keySet())
        {
            templateMessage.addData(new WxMpTemplateData(key, data.get(key) + "\n", "#999"));
        }

        //
        try
        {
            String msgid = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
            log.debug("msgid {}", msgid);
            return msgid;
        }
        catch (WxErrorException e)
        {
            log.error("模板消息发送失败 : {}", e.getMessage());
            throw new ZuvException("send error" + e.getError().getErrorMsg(), e.getError().getErrorCode());
        }
    }

    /**
     * 发送模板消息
     * @param appid 应用标识
     * @param openid 用户标识
     * @param tplid 模板标识
     * @param data 替换数据
     * @param wxapp_appid 小程序标识
     * @param wxapp_pagepath 小程序路径
     * @return 是否成功
     */
    public String sendTemplateMsg(String appid, String openid, String tplid, Map<String, String> data, String wxapp_appid, String wxapp_pagepath)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);

        //
        WxMpTemplateMessage.MiniProgram mp = new WxMpTemplateMessage.MiniProgram(wxapp_appid, wxapp_pagepath, true);

        //
        WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
            .toUser(openid)    //推送用户
            .templateId(tplid)    //发送的消息模板ID
            .miniProgram(mp)    //跳转到小程序
            .build();
        for(String key : data.keySet())
        {
            templateMessage.addData(new WxMpTemplateData(key, data.get(key) + "\n", "#999"));
        }

        //
        try
        {
            String msgid = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
            log.debug("msgid {}", msgid);
            return msgid;
        }
        catch (WxErrorException e)
        {
            log.error("模板消息发送失败 : {}", e.getMessage());
            throw new ZuvException("send error" + e.getError().getErrorMsg(), e.getError().getErrorCode());
        }
    }


    //-----------------------------------------------------------------------------------------
    //客服消息
    //https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140547

    /**
     * 发送客服消息-图文
     *
     * @param appid 应用标识
     * @param openid 用户标识
     * @param url 跳转地址
     * @param picurl 封面图片地址
     * @param title 标题
     * @param description 描述
     * @return 是否成功
     */
    public boolean sendKefuImageMsg(String appid, String openid, String url , String picurl, String title, String description)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);

        //
        WxMpKefuMessage.WxArticle article = new WxMpKefuMessage.WxArticle();
        article.setUrl(url);
        article.setPicUrl(picurl);
        article.setDescription(description);
        article.setTitle(title);
        WxMpKefuMessage build = WxMpKefuMessage.NEWS()
            .toUser(openid)
            .addArticle(article)
            .build();

        //
        try
        {
            boolean result = wxMpService.getKefuService().sendKefuMessage(build);
            log.debug("result {}", result);
            return result;
        }
        catch (WxErrorException e)
        {
            log.error("客服消息发送失败 : {}", e.getMessage());
            throw new ZuvException("send error" + e.getError().getErrorMsg(), e.getError().getErrorCode());
        }
    }

    /**
     * 发送客服消息-文本
     *
     * @param appid 应用标识
     * @param openid 用户标识
     * @param content 文字内容
     * @return 是否成功
     */
    public boolean sendKefuTextMsg(String appid, String openid, String content)
    {
        final WxMpService wxMpService = WechatMpConfig.getMpService(appid);

        //
        WxMpKefuMessage build = WxMpKefuMessage.TEXT()
            .content(content)
            .toUser(openid)
            .build();

        //
        try
        {
            boolean result = wxMpService.getKefuService().sendKefuMessage(build);
            log.debug("result {}", result);
            return result;
        }
        catch (WxErrorException e)
        {
            log.error("客服消息发送失败 : {}", e.getMessage());
            throw new ZuvException("send error" + e.getError().getErrorMsg(), e.getError().getErrorCode());
        }
    }

    //-----------------------------------------------------------------------------------------
    //一次性订阅消息
    //https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1500374289_66bvB

    //-----------------------------------------------------------------------------------------
    //群发接口
    //https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1481187827_i0l21

    //-----------------------------------------------------------------------------------------
    //回复消息
    //https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140543

    //-----------------------------------------------------------------------------------------


}
