/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxpay.config.WechatPayConfig:20190213145104
 *
 * WechatPayConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxpay.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-13 14:51
 * @modify.date     2019-02-13 14:51
 */
@Slf4j
@Configuration
//@ConditionalOnClass(WxPayService.class)
@ConditionalOnProperty(name = "wechat.wxpay.enabled", havingValue = "true")
@EnableConfigurationProperties(WechatPayProperties.class)
public class WechatPayConfig
{

    //-----------------------------------------------------------------------------------------

    private static Map<String, WxPayService> services = Maps.newHashMap();

    public static WxPayService getPayServices(String appid)
    {
        WxPayService wxService = services.get(appid);
        if (wxService == null)
        {
            throw new IllegalArgumentException(String.format("未找到对应appid=[%s]的配置，请核实！", appid));
        }
        return wxService;
    }

    //-----------------------------------------------------------------------------------------

    @Autowired
    private WechatPayProperties properties;

    @PostConstruct
    public void initServices()
    {
        for(WechatPayProperties.Config c : properties.getConfigs())
        {
            String appid = c.getAppId();

            WxPayConfig payConfig = new WxPayConfig();
            payConfig.setAppId(appid);
            payConfig.setMchId(c.getMchId());
            payConfig.setMchKey(c.getMchKey());
            payConfig.setSubAppId(c.getSubAppId());
            payConfig.setSubMchId(c.getSubMchId());
            payConfig.setKeyPath(c.getKeyPath());
            payConfig.setUseSandboxEnv(c.isUseSandbox()); // 可以指定是否使用沙箱环境

            WxPayService service = new WxPayServiceImpl();
            service.setConfig(payConfig);
            services.put(appid, service);
        }
        log.info("init services");
    }

    //-----------------------------------------------------------------------------------------

}
