/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.wechat.wxpay.config.WechatPayProperties:20190213145530
 *
 * WechatPayProperties.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.wechat.wxpay.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2019-02-13 14:55
 * @modify.date     2019-02-13 14:55
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "wechat.wxpay")
public class WechatPayProperties
{


    //-----------------------------------------------------------------------------------------

    private List<Config> configs;

    //-----------------------------------------------------------------------------------------

    @Getter
    @Setter
    public static class Config
    {
        /**
         * 设置微信公众号或者小程序等的appid
         */
        private String appId;

        /**
         * 微信支付商户号
         */
        private String mchId;

        /**
         * 微信支付商户密钥
         */
        private String mchKey;

        /**
         * 服务商模式下的子商户公众账号ID，普通模式请不要配置，请在配置文件中将对应项删除
         */
        private String subAppId;

        /**
         * 服务商模式下的子商户号，普通模式请不要配置，最好是请在配置文件中将对应项删除
         */
        private String subMchId;

        /**
         * apiclient_cert.p12文件的绝对路径，或者如果放在项目中，请以classpath:开头指定
         */
        private String keyPath;

        /**
         * 是否使用沙箱环境
         */
        private boolean useSandbox;
    }

    //-----------------------------------------------------------------------------------------


}
