/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.opentracing;

import cd.connect.opentracing.LoggerSpan;
import cd.connect.opentracing.LoggingSpanTracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerScope
implements Scope {
    private static final Logger log = LoggerFactory.getLogger(LoggerScope.class);
    final LoggerSpan span;
    private Scope wrappedScope;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final boolean finishSpanOnClose;
    private final LoggingSpanTracer tracer;

    LoggerScope(LoggerSpan span, boolean finishSpanOnClose, LoggingSpanTracer tracer) {
        this.span = span;
        this.finishSpanOnClose = finishSpanOnClose;
        this.tracer = tracer;
        log.debug("log activating new scope with span {}", (Object)span.getId());
        if (finishSpanOnClose) {
            span.incInterest();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void setWrappedScope(Scope wrappedScope) {
        this.wrappedScope = wrappedScope;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.span != null && this.finishSpanOnClose) {
                this.span.finish(false);
            }
            this.tracer.cleanupScope(this);
        }
        if (this.wrappedScope != null) {
            this.wrappedScope.close();
        }
    }

    public Span span() {
        return this.span;
    }
}

