/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.opentracing;

import cd.connect.context.ConnectContext;
import cd.connect.opentracing.LoggerScope;
import cd.connect.opentracing.ObjectMapperProvider;
import cd.connect.opentracing.OpenTracingLogger;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggerSpan
implements Span,
SpanContext {
    private static final Logger log = LoggerFactory.getLogger(LoggerSpan.class);
    private Span wrappedSpan;
    private Map<String, String> baggage = new HashMap<String, String>();
    private Map<String, Object> tags = new HashMap<String, Object>();
    private Map<String, Object> logs = new HashMap<String, Object>();
    private List<String> events = new ArrayList<String>();
    private LoggerSpan priorSpan;
    private boolean priorSpanSetting = false;
    private final String id;
    private AtomicInteger garbageCounter = new AtomicInteger(0);
    static final String OPENTRACING_BAGGAGE = "opentracing.baggage";
    static final String OPENTRACING_LOG_MESSAGES = "opentracing.logs";
    static final String OPENTRACING_TAGS = "opentracing.tags";
    static final String OPENTRACING_ID = "opentracing.id";
    static final String OPENTRACING_APPNAME = "opentracing.appName";
    static final String OPENTRACING_ORIGIN_APPNAME = "opentracing.orginApp";

    public LoggerSpan(LoggerScope priorActiveSpan) {
        this.id = UUID.randomUUID().toString();
        if (priorActiveSpan != null) {
            this.baggage.putAll(((LoggerSpan)priorActiveSpan.span()).baggage);
        }
    }

    public boolean isFinished() {
        return this.garbageCounter.get() == 0;
    }

    public void setWrappedSpan(Span wrappedSpan) {
        this.wrappedSpan = wrappedSpan;
    }

    public SpanContext context() {
        return this;
    }

    public LoggerSpan getPriorSpan() {
        return this.priorSpan;
    }

    void setPriorSpan(LoggerSpan newPriorSpan) {
        LoggerSpan priorSpan = newPriorSpan;
        if (this.priorSpanSetting) {
            this.priorSpan = newPriorSpan;
        } else {
            this.priorSpanSetting = true;
            if (this.priorSpan != newPriorSpan && newPriorSpan != null) {
                this.baggage.putAll(priorSpan.baggage);
            }
            if (this.priorSpan != null && this.priorSpan != newPriorSpan && newPriorSpan != null) {
                priorSpan.setPriorSpan(this.priorSpan);
            }
            this.priorSpan = newPriorSpan;
            this.priorSpanSetting = false;
        }
    }

    public Span setTag(String key, String value) {
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
        if (this.wrappedSpan != null) {
            this.wrappedSpan.setTag(key, value);
        }
        this.updateLoggedTags();
        return this;
    }

    public Span setTag(String key, boolean value) {
        this.tags.put(key, value);
        if (this.wrappedSpan != null) {
            this.wrappedSpan.setTag(key, value);
        }
        this.updateLoggedTags();
        return this;
    }

    public Span setTag(String key, Number value) {
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
        if (this.wrappedSpan != null) {
            this.wrappedSpan.setTag(key, value);
        }
        this.updateLoggedTags();
        return null;
    }

    public Span log(Map<String, ?> fields) {
        fields.forEach((key, value) -> this.logs.put((String)key, value));
        this.wrappedSpan.log(fields);
        this.updateLoggedMessages();
        return this;
    }

    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        this.log(fields);
        this.wrappedSpan.log(timestampMicroseconds, fields);
        this.updateLoggedMessages();
        return this;
    }

    public Span log(String event) {
        this.events.add(event);
        this.wrappedSpan.log(event);
        return this;
    }

    public Span log(String event, String message) {
        this.events.add(event + ":" + message);
        this.wrappedSpan.log(event);
        return this;
    }

    public Span log(long timestampMicroseconds, String event) {
        this.events.add(event + "@" + timestampMicroseconds);
        this.wrappedSpan.log(timestampMicroseconds, event);
        return this;
    }

    public Span setBaggageItem(String key, String value) {
        this.baggage.put(key, value);
        this.wrappedSpan.setBaggageItem(key, value);
        this.updateLoggedBaggage();
        return this;
    }

    private String tryMany(Map<String, String> source, String ... names) {
        List<String> acutalNames = Arrays.asList(names);
        Map.Entry found = source.entrySet().stream().filter(e -> acutalNames.contains(e.getKey())).findFirst().orElse(null);
        if (found != null) {
            return source.remove(found.getKey());
        }
        return null;
    }

    private void updateLoggedBaggage() {
        if (this.id.equals(MDC.get((String)OPENTRACING_ID))) {
            String scenarioId;
            HashMap<String, String> clonedBaggage = new HashMap<String, String>(this.baggage);
            String requestId = this.tryMany(clonedBaggage, OpenTracingLogger.WELL_KNOWN_REQUEST_ID, "requestid", "request-id");
            if (requestId != null) {
                ConnectContext.requestId.set(requestId);
            }
            if ((scenarioId = this.tryMany(clonedBaggage, OpenTracingLogger.WELL_KNOWN_SCENARIO_ID, "scenarioId", "scenario-id")) != null) {
                ConnectContext.scenarioId.set(scenarioId);
            }
            clonedBaggage.remove(OpenTracingLogger.WELL_KNOWN_ORIGIN_APP);
            MDC.put((String)OPENTRACING_BAGGAGE, (String)ObjectMapperProvider.wrapObject(clonedBaggage));
        }
    }

    private void updateLoggedMessages() {
        if (this.id.equals(MDC.get((String)OPENTRACING_ID))) {
            MDC.put((String)OPENTRACING_LOG_MESSAGES, (String)ObjectMapperProvider.wrapObject(this.logs));
        }
    }

    private void updateLoggedTags() {
        if (this.id.equals(MDC.get((String)OPENTRACING_ID))) {
            MDC.put((String)OPENTRACING_TAGS, (String)ObjectMapperProvider.wrapObject(this.tags));
        }
    }

    void setActive(String appName) {
        MDC.put((String)OPENTRACING_ID, (String)this.id);
        this.updateLoggedBaggage();
        this.updateLoggedMessages();
        this.updateLoggedTags();
        MDC.put((String)OPENTRACING_APPNAME, (String)appName);
        String originApp = this.getBaggageItem(OpenTracingLogger.WELL_KNOWN_ORIGIN_APP);
        if (originApp != null) {
            MDC.put((String)OPENTRACING_ORIGIN_APPNAME, (String)originApp);
        }
    }

    void removeActive() {
        if (this.id.equals(MDC.get((String)OPENTRACING_ID))) {
            ConnectContext.requestId.remove();
            ConnectContext.scenarioId.remove();
            MDC.remove((String)OPENTRACING_ID);
            MDC.remove((String)OPENTRACING_TAGS);
            MDC.remove((String)OPENTRACING_BAGGAGE);
            MDC.remove((String)OPENTRACING_LOG_MESSAGES);
            MDC.remove((String)OPENTRACING_APPNAME);
            MDC.remove((String)OPENTRACING_ORIGIN_APPNAME);
        }
    }

    String getId() {
        return this.id;
    }

    Span getWrappedSpan() {
        return this.wrappedSpan;
    }

    public String getBaggageItem(String key) {
        return this.wrappedSpan.getBaggageItem(key);
    }

    public Span setOperationName(String operationName) {
        return this;
    }

    public void finish(boolean callFinishOnWrappedSpan) {
        if (this.garbageCounter.decrementAndGet() == 0) {
            this.removeActive();
        }
        if (callFinishOnWrappedSpan) {
            this.wrappedSpan.finish();
        }
    }

    public void finish() {
        this.finish(true);
    }

    public void finish(long finishMicros) {
        this.finish();
    }

    protected void incInterest() {
        this.garbageCounter.incrementAndGet();
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }
}

