/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.opentracing;

import cd.connect.opentracing.LoggerScope;
import cd.connect.opentracing.LoggerSpan;
import cd.connect.opentracing.OpenTracingLogger;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSpanTracer
implements Tracer {
    private static final Logger log = LoggerFactory.getLogger(LoggingSpanTracer.class);
    private final Tracer wrappedTracer;
    protected ThreadLocal<Queue<LoggerScope>> activeScopeStack = new ThreadLocal();
    private String appName;
    private final ScopeManager scopeManager = new ScopeManager(){

        public Scope activate(Span span, boolean finishSpanOnClose) {
            LoggerSpan loggerSpan = (LoggerSpan)span;
            LoggerScope newScope = new LoggerScope(loggerSpan, finishSpanOnClose, LoggingSpanTracer.this);
            Scope wrappedScope = LoggingSpanTracer.this.wrappedTracer.scopeManager().activate(loggerSpan.getWrappedSpan(), finishSpanOnClose);
            newScope.setWrappedScope(wrappedScope);
            loggerSpan.setActive(LoggingSpanTracer.this.appName);
            if (loggerSpan.getBaggageItem(OpenTracingLogger.WELL_KNOWN_REQUEST_ID) == null) {
                loggerSpan.setBaggageItem(OpenTracingLogger.WELL_KNOWN_REQUEST_ID, OpenTracingLogger.randomRequestIdProvider.get());
            }
            if (loggerSpan.getBaggageItem(OpenTracingLogger.WELL_KNOWN_ORIGIN_APP) == null) {
                loggerSpan.setBaggageItem(OpenTracingLogger.WELL_KNOWN_ORIGIN_APP, LoggingSpanTracer.this.appName);
            }
            LoggingSpanTracer.this.pushScope(newScope);
            return newScope;
        }

        public Scope active() {
            return LoggingSpanTracer.this.activeScope();
        }
    };

    void pushScope(LoggerScope scope) {
        Queue<LoggerScope> scopes = this.activeScopeStack.get();
        if (scopes == null) {
            scopes = new LinkedList<LoggerScope>();
            this.activeScopeStack.set(scopes);
        }
        scopes.add(scope);
    }

    LoggerScope popScope() {
        Queue<LoggerScope> scopes = this.activeScopeStack.get();
        if (scopes != null && scopes.size() > 0) {
            LoggerScope poll = scopes.poll();
            log.debug("dropping scope for span {}", (Object)poll.span.getId());
            return scopes.peek();
        }
        return null;
    }

    LoggerScope activeScope() {
        Queue<LoggerScope> scopes = this.activeScopeStack.get();
        return scopes != null && scopes.size() > 0 ? scopes.peek() : null;
    }

    boolean activeScopeClosed() {
        Queue<LoggerScope> scopes = this.activeScopeStack.get();
        return scopes != null && scopes.size() > 0 && scopes.peek().isClosed();
    }

    public LoggingSpanTracer(Tracer wrappedTracer) {
        this.wrappedTracer = wrappedTracer;
        this.appName = System.getProperty("app.name");
        if (this.appName == null) {
            try {
                this.appName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.appName = "unknown-app";
            }
        }
    }

    private LoggerScope cleanScopes() {
        if (this.activeScopeClosed()) {
            this.popScope();
            LoggerScope scope = this.activeScope();
            while (scope != null && scope.isClosed()) {
                scope = this.popScope();
            }
            if (scope != null && !scope.span.isFinished()) {
                scope.span.setActive(this.appName);
            }
            log.debug("scope count outstanding: {}", (Object)this.activeScopeStack.get().size());
            return scope;
        }
        return this.activeScope();
    }

    void cleanupScope(LoggerScope scope) {
        scope.span.removeActive();
        log.debug("loggerscope with span {} has been finished", (Object)scope.span.getId());
        this.cleanScopes();
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        LoggerScope scope = this.cleanScopes();
        return scope == null ? null : scope.span();
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new LoggingSpanBuilder(this.wrappedTracer.buildSpan(operationName));
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C c) {
        LoggerSpan span = (LoggerSpan)spanContext;
        this.wrappedTracer.inject(span.getWrappedSpan().context(), format, c);
    }

    public <C> SpanContext extract(Format<C> format, C c) {
        SpanContext ctx = this.wrappedTracer.extract(format, c);
        LoggerSpan span = null;
        if (ctx != null) {
            span = new LoggerSpan(null);
            if (ctx instanceof Span) {
                span.setWrappedSpan((Span)ctx);
            }
            LoggerSpan finalSpan = span;
            ctx.baggageItems().forEach(entry -> finalSpan.setBaggageItem((String)entry.getKey(), (String)entry.getValue()));
        }
        return span;
    }

    class LoggingSpanBuilder
    implements Tracer.SpanBuilder {
        private Tracer.SpanBuilder spanBuilder;
        private LoggerSpan loggerSpan;

        LoggingSpanBuilder(Tracer.SpanBuilder spanBuilder) {
            this.spanBuilder = spanBuilder;
            this.loggerSpan = new LoggerSpan(LoggingSpanTracer.this.activeScope());
        }

        public Tracer.SpanBuilder asChildOf(SpanContext parent) {
            if (parent instanceof LoggerSpan) {
                this.spanBuilder = this.spanBuilder.asChildOf(((LoggerSpan)parent).getWrappedSpan());
                this.loggerSpan.setPriorSpan((LoggerSpan)parent);
            } else {
                this.spanBuilder = this.spanBuilder.asChildOf(parent);
            }
            return this;
        }

        public Tracer.SpanBuilder asChildOf(Span parent) {
            if (parent instanceof LoggerSpan) {
                this.spanBuilder = this.spanBuilder.asChildOf(((LoggerSpan)parent).getWrappedSpan());
                this.loggerSpan.setPriorSpan((LoggerSpan)parent);
            } else {
                this.spanBuilder = this.spanBuilder.asChildOf(parent);
            }
            return this;
        }

        public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if ("child_of".equals(referenceType)) {
                return this.asChildOf(referencedContext);
            }
            if (referencedContext instanceof LoggerSpan) {
                this.spanBuilder = this.spanBuilder.addReference(referenceType, ((LoggerSpan)referencedContext).getWrappedSpan().context());
                this.loggerSpan.setPriorSpan((LoggerSpan)referencedContext);
            } else {
                this.spanBuilder = this.spanBuilder.addReference(referenceType, referencedContext);
            }
            return this;
        }

        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.spanBuilder = this.spanBuilder.ignoreActiveSpan();
            this.loggerSpan.setPriorSpan(null);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, String value) {
            this.loggerSpan.setTag(key, value);
            this.spanBuilder = this.spanBuilder.withTag(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, boolean value) {
            this.loggerSpan.setTag(key, value);
            this.spanBuilder = this.spanBuilder.withTag(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, Number value) {
            this.loggerSpan.setTag(key, value);
            this.spanBuilder = this.spanBuilder.withTag(key, value);
            return this;
        }

        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            this.spanBuilder = this.spanBuilder.withStartTimestamp(microseconds);
            return this;
        }

        public Scope startActive(boolean finishSpanOnClose) {
            Scope scope = this.spanBuilder.startActive(finishSpanOnClose);
            this.loggerSpan.setWrappedSpan(scope.span());
            LoggerScope newScope = new LoggerScope(this.loggerSpan, finishSpanOnClose, LoggingSpanTracer.this);
            newScope.setWrappedScope(scope);
            this.loggerSpan.setActive(LoggingSpanTracer.this.appName);
            if (this.loggerSpan.getBaggageItem(OpenTracingLogger.WELL_KNOWN_REQUEST_ID) == null) {
                this.loggerSpan.setBaggageItem(OpenTracingLogger.WELL_KNOWN_REQUEST_ID, OpenTracingLogger.randomRequestIdProvider.get());
            }
            LoggingSpanTracer.this.pushScope(newScope);
            return newScope;
        }

        public Span startManual() {
            return this.startActive(false).span();
        }

        public Span start() {
            this.loggerSpan.setWrappedSpan(this.spanBuilder.start());
            return this.loggerSpan;
        }
    }
}

